/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.util.webserver;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.lang3.StringUtils;
import org.kawanfw.sql.api.util.webserver.WebServerUtil;
import org.kawanfw.sql.version.VersionWrapper;

public class ParametersExtractor {
    String[] args;
    private int port;
    private String host;
    private boolean isStartCommand;
    private File propertiesFile;

    public ParametersExtractor(String[] args) throws ParseException {
        this.args = args;
        this.treat();
    }

    private void treat() throws ParseException {
        Options options = ParametersExtractor.createOptions();
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        cmd = this.chekParameters(options, (CommandLineParser)parser);
        this.port = 9090;
        if (cmd.hasOption("port")) {
            String portStr = cmd.getOptionValue("port");
            try {
                this.port = Integer.parseInt(portStr);
            }
            catch (Exception e) {
                WebServerUtil.displayErrorAndExit("The port parameter is not numeric: " + portStr + ".");
            }
        }
        if (cmd.hasOption("start")) {
            this.isStartCommand = true;
            if (!cmd.hasOption("host")) {
                WebServerUtil.displayErrorAndExit("Missing host option.");
            }
            this.host = cmd.getOptionValue("host");
            this.propertiesFile = null;
            if (!cmd.hasOption("properties")) {
                this.propertiesFile = ParametersExtractor.getDefaultPropertiesFile();
                if (this.propertiesFile == null) {
                    WebServerUtil.displayErrorAndExit("Missing properties option.");
                }
            } else {
                this.propertiesFile = new File(cmd.getOptionValue("properties"));
            }
        } else {
            this.isStartCommand = false;
        }
    }

    private CommandLine chekParameters(Options options, CommandLineParser parser) throws ParseException {
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, this.args);
        }
        catch (UnrecognizedOptionException e) {
            System.out.println(e.getMessage());
            System.out.println();
            WebServerUtil.printUsage(options);
            WebServerUtil.systemExitWrapper(-1);
        }
        if (cmd.hasOption("help")) {
            WebServerUtil.printUsage(options);
            WebServerUtil.systemExitWrapper(-1);
        }
        if (cmd.hasOption("version")) {
            System.out.println(VersionWrapper.getServerVersion());
            System.out.println();
            WebServerUtil.systemExitWrapper(0);
        }
        if (!cmd.hasOption("start") && !cmd.hasOption("stop")) {
            System.err.println("Missing start or stop option. Please correct and retry.");
            System.out.println();
            WebServerUtil.printUsage(options);
            WebServerUtil.systemExitWrapper(-1);
        }
        return cmd;
    }

    public boolean isStartCommand() {
        return this.isStartCommand;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    private static Options createOptions() throws IllegalArgumentException {
        Options options = new Options();
        options.addOption("help", false, "print this message");
        options.addOption("start", false, "start the SQL Web server");
        options.addOption("stop", false, "stop the SQL Web server");
        options.addOption("version", false, "print version");
        String propertiesOptionMesssage = ParametersExtractor.getPropertiesOptionMessage();
        Option propertiesOption = Option.builder((String)"properties").argName("file").hasArg().desc(propertiesOptionMesssage).build();
        Option hostOption = Option.builder((String)"host").argName("hostname").hasArg().desc("hostname of the Web server").build();
        Option portOption = Option.builder((String)"port").argName("port number").hasArg().desc("port number of the Web server. Defaults to 9090").build();
        options.addOption(propertiesOption);
        options.addOption(hostOption);
        options.addOption(portOption);
        return options;
    }

    private static String getPropertiesOptionMessage() {
        String message = "properties file to use for this SQL Web server session. ";
        File propertiesFile = ParametersExtractor.getDefaultPropertiesFile();
        if (propertiesFile != null) {
            message = String.valueOf(message) + "Defaults to " + propertiesFile;
        }
        return message;
    }

    private static File getDefaultPropertiesFile() {
        File defaultPropertiesFile = null;
        String aceqlHome = System.getenv("ACEQL_HOME");
        if (aceqlHome != null) {
            if ((aceqlHome = aceqlHome.replaceAll("\"", "")).endsWith(File.separator)) {
                aceqlHome = StringUtils.substringBeforeLast((String)aceqlHome, (String)File.separator);
            }
            defaultPropertiesFile = new File(String.valueOf(aceqlHome) + File.separator + "conf" + File.separator + "aceql-server.properties");
        }
        return defaultPropertiesFile;
    }
}

