/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.util.webserver;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.sql.SQLException;
import org.apache.catalina.LifecycleException;
import org.apache.commons.lang3.SystemUtils;
import org.kawanfw.sql.api.server.DatabaseConfigurationException;
import org.kawanfw.sql.tomcat.TomcatStarter;
import org.kawanfw.sql.tomcat.TomcatStarterUtil;
import org.kawanfw.sql.tomcat.util.PortSemaphoreFile;
import org.kawanfw.sql.util.FrameworkDebug;

public class WebServerApiWrapper {
    private static String CR_LF = System.getProperty("line.separator");
    private static boolean DEBUG = FrameworkDebug.isSet(WebServerApiWrapper.class);
    public static final int DEFAULT_PORT = 9090;

    public void startServer(String host, int port, File propertiesFile) throws ConnectException, IOException, DatabaseConfigurationException, LifecycleException, SQLException {
        WebServerApiWrapper.debug("propertiesFiles: " + propertiesFile);
        if (host == null) {
            throw new DatabaseConfigurationException("host parameter can not be null.");
        }
        if (port <= 0) {
            throw new DatabaseConfigurationException("port parameter can not be null.");
        }
        if (propertiesFile == null) {
            throw new DatabaseConfigurationException("propertiesFile parameter can not be null.");
        }
        if (!propertiesFile.exists()) {
            throw new DatabaseConfigurationException("The properties file " + propertiesFile + " does not exists. " + "Please correct and retry.");
        }
        if (!TomcatStarterUtil.available(port)) {
            throw new ConnectException("The port " + port + " is not available for starting Web server. " + "Please correct and retry.");
        }
        PortSemaphoreFile portSemaphoreFile = new PortSemaphoreFile(port);
        try {
            if (!portSemaphoreFile.exists()) {
                portSemaphoreFile.create();
            }
        }
        catch (IOException e) {
            throw new IOException("Web server can not start. Impossible to create the semaphore file: " + portSemaphoreFile.getSemaphoreFile() + CR_LF + "Create manually the semapahore file to start the Web server on port " + port + ".", e);
        }
        if (SystemUtils.IS_OS_UNIX) {
            System.setProperty("java.security.egd", "file:/dev/./urandom");
            WebServerApiWrapper.debug("java.security.egd: " + System.getProperty("java.security.egd"));
        }
        TomcatStarter tomcatStarter = new TomcatStarter(host, port, propertiesFile);
        tomcatStarter.startTomcat();
    }

    public void startServer(String host, File propertiesFile) throws ConnectException, IOException, DatabaseConfigurationException, LifecycleException, SQLException {
        this.startServer(host, 9090, propertiesFile);
    }

    public void stopServer() throws IOException {
        this.stopServer(9090);
    }

    public void stopServer(int port) throws IOException {
        PortSemaphoreFile portSemaphoreFile = new PortSemaphoreFile(port);
        if (!portSemaphoreFile.exists()) {
            throw new ConnectException("WARNING! There is no AceQL HTTP Web server running on port " + port);
        }
        try {
            portSemaphoreFile.delete();
        }
        catch (IOException ioe) {
            throw new IOException("Can not stop the Web server. Please delete manually the semaphore file " + portSemaphoreFile.getSemaphoreFile() + " and then retry. ", ioe);
        }
        if (TomcatStarterUtil.available(port)) {
            throw new ConnectException("WARNING! There is no SQL Web server running on port " + port);
        }
    }

    public boolean isServerRunning() {
        PortSemaphoreFile portSemaphoreFile = new PortSemaphoreFile(9090);
        return portSemaphoreFile.exists();
    }

    public boolean isServerRunning(int port) {
        PortSemaphoreFile portSemaphoreFile = new PortSemaphoreFile(port);
        return portSemaphoreFile.exists();
    }

    private static void debug(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }
}

