/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.jdbc.metadata;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.kawanfw.sql.util.Tag;

public class AceQLArray
implements Array {
    private static final String KAWANFW_NOT_SUPPORTED_METHOD = String.valueOf(Tag.PRODUCT) + "Method is not yet implemented.";
    private String baseTypeName;
    private int baseType;
    private String[] arrayValues;

    public AceQLArray() {
    }

    public AceQLArray(Array array) throws SQLException {
        if (array == null) {
            this.baseTypeName = "NULL";
            this.baseType = 0;
            return;
        }
        this.baseTypeName = array.getBaseTypeName();
        this.baseType = array.getBaseType();
        if (this.baseType == 91) {
            Date[] objectArray = (Date[])array.getArray();
            this.arrayValues = new String[objectArray.length];
            int i = 0;
            while (i < objectArray.length) {
                this.arrayValues[i] = "" + objectArray[i].getTime();
                ++i;
            }
        } else if (this.baseType == 93) {
            Timestamp[] objectArray = (Timestamp[])array.getArray();
            this.arrayValues = new String[objectArray.length];
            int i = 0;
            while (i < objectArray.length) {
                this.arrayValues[i] = "" + objectArray[i].getTime();
                ++i;
            }
        } else if (this.baseType == 92) {
            Timestamp[] objectArray = (Timestamp[])array.getArray();
            this.arrayValues = new String[objectArray.length];
            int i = 0;
            while (i < objectArray.length) {
                this.arrayValues[i] = "" + objectArray[i].getTime();
                ++i;
            }
        } else {
            Object[] objectArray = (Object[])array.getArray();
            this.arrayValues = new String[objectArray.length];
            int i = 0;
            while (i < objectArray.length) {
                this.arrayValues[i] = objectArray[i].toString();
                ++i;
            }
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.baseTypeName;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.baseType;
    }

    @Override
    public Object getArray() throws SQLException {
        if (this.baseTypeName.equals("NULL")) {
            return null;
        }
        if (this.isString(this.baseType)) {
            return this.arrayValues;
        }
        if (this.isBigDecimal(this.baseType)) {
            BigDecimal[] theArray = new BigDecimal[this.arrayValues.length];
            int i = 0;
            while (i < this.arrayValues.length) {
                theArray[i] = new BigDecimal(this.arrayValues[i]);
                ++i;
            }
            return theArray;
        }
        if (this.isBoolean(this.baseType)) {
            Boolean[] theArray = new Boolean[this.arrayValues.length];
            int i = 0;
            while (i < this.arrayValues.length) {
                theArray[i] = Boolean.parseBoolean(this.arrayValues[i]);
                ++i;
            }
            return theArray;
        }
        if (this.isShort(this.baseType)) {
            Short[] theArray = new Short[this.arrayValues.length];
            int i = 0;
            while (i < this.arrayValues.length) {
                theArray[i] = Short.parseShort(this.arrayValues[i]);
                ++i;
            }
            return theArray;
        }
        if (this.isInt(this.baseType)) {
            Integer[] theArray = new Integer[this.arrayValues.length];
            int i = 0;
            while (i < this.arrayValues.length) {
                theArray[i] = Integer.parseInt(this.arrayValues[i]);
                ++i;
            }
            return theArray;
        }
        if (this.isLong(this.baseType)) {
            Long[] theArray = new Long[this.arrayValues.length];
            int i = 0;
            while (i < this.arrayValues.length) {
                theArray[i] = Long.parseLong(this.arrayValues[i]);
                ++i;
            }
            return theArray;
        }
        if (this.isFloat(this.baseType)) {
            Float[] theArray = new Float[this.arrayValues.length];
            int i = 0;
            while (i < this.arrayValues.length) {
                theArray[i] = Float.valueOf(Float.parseFloat(this.arrayValues[i]));
                ++i;
            }
            return theArray;
        }
        if (this.isDouble(this.baseType)) {
            Double[] theArray = new Double[this.arrayValues.length];
            int i = 0;
            while (i < this.arrayValues.length) {
                theArray[i] = Double.parseDouble(this.arrayValues[i]);
                ++i;
            }
            return theArray;
        }
        return this.arrayValues;
    }

    private boolean isShort(int baseType) {
        return baseType == 5;
    }

    private boolean isLong(int baseType) {
        return baseType == -5 || baseType == 91 || baseType == 93 || baseType == 92;
    }

    private boolean isBoolean(int baseType) {
        return baseType == 16;
    }

    private boolean isFloat(int baseType) {
        return baseType == 7;
    }

    private boolean isBigDecimal(int baseType) {
        return baseType == 2 || baseType == 3;
    }

    private boolean isDouble(int baseType) {
        return baseType == 7 || baseType == 6;
    }

    private boolean isInt(int baseType) {
        return baseType == 4;
    }

    private boolean isString(int baseType) {
        return baseType == 1 || baseType == 12 || baseType == -1;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException(KAWANFW_NOT_SUPPORTED_METHOD);
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        throw new SQLFeatureNotSupportedException(KAWANFW_NOT_SUPPORTED_METHOD);
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException(KAWANFW_NOT_SUPPORTED_METHOD);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new SQLFeatureNotSupportedException(KAWANFW_NOT_SUPPORTED_METHOD);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException(KAWANFW_NOT_SUPPORTED_METHOD);
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new SQLFeatureNotSupportedException(KAWANFW_NOT_SUPPORTED_METHOD);
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException(KAWANFW_NOT_SUPPORTED_METHOD);
    }

    @Override
    public void free() throws SQLException {
    }

    public String toString() {
        return "AceQLArray [baseTypeName=" + this.baseTypeName + ", baseType=" + this.baseType + ", arrayValues=" + Arrays.toString(this.arrayValues) + "]";
    }
}

