/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.kawanfw.sql.api.util.SqlUtil;
import org.kawanfw.sql.metadata.Column;
import org.kawanfw.sql.metadata.ExportedKey;
import org.kawanfw.sql.metadata.ImportedKey;
import org.kawanfw.sql.metadata.Index;
import org.kawanfw.sql.metadata.JdbcDatabaseMetaData;
import org.kawanfw.sql.metadata.PrimaryKey;
import org.kawanfw.sql.metadata.Table;
import org.kawanfw.sql.metadata.util.MetaDataJavaUtil;
import org.kawanfw.sql.util.FrameworkDebug;

public class AceQLMetaData {
    private static boolean DEBUG = FrameworkDebug.isSet(AceQLMetaData.class);
    private Connection connection = null;
    private String catalog = null;
    private String schema = null;
    private Set<String> tableNamesSet = new HashSet<String>();

    public AceQLMetaData(Connection connection) throws SQLException {
        this.connection = connection;
        List<String> tableNames = this.getTableNames();
        for (String tableName : tableNames) {
            this.tableNamesSet.add(tableName.toLowerCase());
        }
    }

    public AceQLMetaData(Connection connection, String catalog, String schema) throws SQLException {
        this(connection);
        this.catalog = catalog;
        this.schema = schema;
    }

    public List<String> getSchemas() throws SQLException {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        String columnLabel = "TABLE_SCHEM";
        ResultSet rs = databaseMetaData.getSchemas();
        ArrayList<String> schemas = new ArrayList<String>();
        while (rs.next()) {
            schemas.add(rs.getString(columnLabel));
        }
        return schemas;
    }

    public JdbcDatabaseMetaData getJdbcDatabaseMetaData() throws SQLException {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        JdbcDatabaseMetaData jdbcDatabaseMetaData = new JdbcDatabaseMetaData();
        jdbcDatabaseMetaData.setDatabaseMetaDataHolder(databaseMetaData);
        return jdbcDatabaseMetaData;
    }

    public List<String> getCatalogs() throws SQLException {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        ResultSet rs = databaseMetaData.getCatalogs();
        String columnLabel = "TABLE_CAT";
        ArrayList<String> schemas = new ArrayList<String>();
        while (rs.next()) {
            schemas.add(rs.getString(columnLabel));
        }
        return schemas;
    }

    public List<String> getTableTypes() throws SQLException {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        ResultSet rs = databaseMetaData.getTableTypes();
        ArrayList<String> tableTypes = new ArrayList<String>();
        while (rs.next()) {
            tableTypes.add(rs.getString(1));
        }
        return tableTypes;
    }

    public List<String> getTableNames(String filterTableType) throws SQLException {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        String[] types = new String[]{"TABLE", "VIEW", "GLOBAL TEMPORARY", "LOCAL TEMPORARY", "ALIAS", "SYNONYM"};
        ResultSet rs = databaseMetaData.getTables(this.catalog, this.schema, null, types);
        ArrayList<String> tableNames = new ArrayList<String>();
        while (rs.next()) {
            String schema = rs.getString(2);
            SqlUtil sqlUtil = new SqlUtil(this.connection);
            boolean doContinue = false;
            if (doContinue = this.checkDoContinue(databaseMetaData, schema, sqlUtil, doContinue)) continue;
            String tableName = rs.getString(3);
            String tableType = rs.getString(4);
            if (filterTableType != null && !filterTableType.equalsIgnoreCase(tableType)) continue;
            this.debug("catalog : " + rs.getString(1) + " schema : " + rs.getString(2) + " tableName: " + tableName + " TABLE_TYPE: " + rs.getString(4));
            tableNames.add(tableName);
        }
        return tableNames;
    }

    private boolean checkDoContinue(DatabaseMetaData databaseMetaData, String schema, SqlUtil sqlUtil, boolean doContinue) throws SQLException {
        boolean doContinueNew = doContinue;
        if (sqlUtil.isPostgreSQL() && !schema.equalsIgnoreCase("public") || sqlUtil.isMySQL() && schema != null || sqlUtil.isSQLServer() && !schema.equalsIgnoreCase("dbo") || sqlUtil.isDB2() && (schema == null || !schema.equalsIgnoreCase(databaseMetaData.getUserName())) || sqlUtil.isOracle() && (schema == null || !schema.equalsIgnoreCase(databaseMetaData.getUserName()))) {
            doContinueNew = true;
        }
        return doContinueNew;
    }

    public List<String> getTableNames() throws SQLException {
        return this.getTableNames(null);
    }

    public List<ExportedKey> getExportedKeys(String tableName) throws SQLException {
        Objects.requireNonNull(tableName, "tableName cannot be null!");
        if (!this.tableNamesSet.contains(tableName.toLowerCase())) {
            throw new IllegalArgumentException("table does not exists: " + tableName);
        }
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        ResultSet rs = databaseMetaData.getExportedKeys(this.catalog, this.schema, tableName);
        ArrayList<ExportedKey> exportedKeys = new ArrayList<ExportedKey>();
        while (rs.next()) {
            ExportedKey exportedKey = new ExportedKey();
            int i = 1;
            exportedKey.setCatalog(rs.getString(i++));
            exportedKey.setSchema(rs.getString(i++));
            exportedKey.setPrimaryKeyTable(rs.getString(i++));
            exportedKey.setPrimaryKeyColumn(rs.getString(i++));
            exportedKey.setForeignKeyCatalog(rs.getString(i++));
            exportedKey.setForeignKeySchema(rs.getString(i++));
            exportedKey.setForeignKeyTable(rs.getString(i++));
            exportedKey.setForeignKeyColumn(rs.getString(i++));
            exportedKey.setKeySequence(rs.getInt(i++));
            exportedKey.setUpdateRule(MetaDataJavaUtil.decodeRule(rs.getInt(i++)));
            exportedKey.setDeleteRule(MetaDataJavaUtil.decodeRule(rs.getInt(i++)));
            exportedKey.setForeignKeyName(rs.getString(i++));
            exportedKey.setPrimaryKeyName(rs.getString(i++));
            exportedKey.setDeferrability(rs.getInt(i++));
            exportedKeys.add(exportedKey);
        }
        return exportedKeys;
    }

    public List<ImportedKey> getImportedKeys(String tableName) throws SQLException {
        Objects.requireNonNull(tableName, "tableName cannot be null!");
        if (!this.tableNamesSet.contains(tableName.toLowerCase())) {
            throw new IllegalArgumentException("table does not exists: " + tableName);
        }
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        ResultSet rs = databaseMetaData.getImportedKeys(this.catalog, this.schema, tableName);
        ArrayList<ImportedKey> importedKeys = new ArrayList<ImportedKey>();
        while (rs.next()) {
            ImportedKey importedKey = new ImportedKey();
            int i = 1;
            importedKey.setCatalog(rs.getString(i++));
            importedKey.setSchema(rs.getString(i++));
            importedKey.setPrimaryKeyTable(rs.getString(i++));
            importedKey.setPrimaryKeyColumn(rs.getString(i++));
            importedKey.setForeignKeyCatalog(rs.getString(i++));
            importedKey.setForeignKeySchema(rs.getString(i++));
            importedKey.setForeignKeyTable(rs.getString(i++));
            importedKey.setForeignKeyColumn(rs.getString(i++));
            importedKey.setKeySequence(rs.getInt(i++));
            importedKey.setUpdateRule(MetaDataJavaUtil.decodeRule(rs.getInt(i++)));
            importedKey.setDeleteRule(MetaDataJavaUtil.decodeRule(rs.getInt(i++)));
            importedKey.setForeignKeyName(rs.getString(i++));
            importedKey.setPrimaryKeyName(rs.getString(i++));
            importedKey.setDeferrability(rs.getInt(i++));
            importedKeys.add(importedKey);
        }
        return importedKeys;
    }

    public List<PrimaryKey> getPrimaryKeys(String tableName) throws SQLException {
        Objects.requireNonNull(tableName, "tableName cannot be null!");
        if (!this.tableNamesSet.contains(tableName.toLowerCase())) {
            throw new IllegalArgumentException("table does not exists: " + tableName);
        }
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        ResultSet rs = databaseMetaData.getPrimaryKeys(this.catalog, this.schema, tableName);
        ArrayList<PrimaryKey> primaryKeys = new ArrayList<PrimaryKey>();
        while (rs.next()) {
            PrimaryKey primaryKey = new PrimaryKey();
            int i = 1;
            primaryKey.setCatalog(rs.getString(i++));
            primaryKey.setSchema(rs.getString(i++));
            primaryKey.setTableName(rs.getString(i++));
            primaryKey.setColumnName(rs.getString(i++));
            primaryKey.setKeySequence(rs.getInt(i++));
            primaryKey.setPrimaryKeyName(rs.getString(i++));
            primaryKeys.add(primaryKey);
        }
        return primaryKeys;
    }

    public List<Index> getIndexes(String tableName) throws SQLException {
        Objects.requireNonNull(tableName, "tableName cannot be null!");
        if (!this.tableNamesSet.contains(tableName.toLowerCase())) {
            throw new IllegalArgumentException("table does not exists: " + tableName);
        }
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        ResultSet rs = databaseMetaData.getIndexInfo(this.catalog, null, tableName, false, true);
        ArrayList<Index> indexes = new ArrayList<Index>();
        while (rs.next()) {
            Index index = new Index();
            int i = 1;
            index.setCatalog(rs.getString(i++));
            index.setSchema(rs.getString(i++));
            index.setTableName(rs.getString(i++));
            index.setNonUnique(rs.getBoolean(i++));
            index.setIndexQualifier(rs.getString(i++));
            index.setIndexName(rs.getString(i++));
            index.setType(MetaDataJavaUtil.decodeType(rs.getInt(i++)));
            index.setOrdinalPosition(rs.getInt(i++));
            index.setColumnName(rs.getString(i++));
            index.setAscendingOrDescending(rs.getString(i++));
            index.setCardinality(rs.getInt(i++));
            index.setPages(rs.getInt(i++));
            index.setFilterCondition(rs.getString(i++));
            indexes.add(index);
        }
        return indexes;
    }

    public List<Column> getColumns(String tableName) throws SQLException {
        Objects.requireNonNull(tableName, "tableName cannot be null!");
        if (!this.tableNamesSet.contains(tableName.toLowerCase())) {
            throw new IllegalArgumentException("table does not exists: " + tableName);
        }
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        ResultSet rs = databaseMetaData.getColumns(this.catalog, this.schema, tableName, null);
        ArrayList<Column> columns = new ArrayList<Column>();
        while (rs.next()) {
            Column column = new Column();
            int i = 1;
            column.setCatalog(rs.getString(i++));
            column.setSchema(rs.getString(i++));
            column.setTableName(rs.getString(i++));
            column.setColumnName(rs.getString(i++));
            int n = ++i;
            column.setTypeName(rs.getString(n));
            int n2 = ++i;
            ++i;
            column.setSize(rs.getInt(n2));
            int n3 = ++i;
            column.setDecimalDigits(rs.getInt(n3));
            int n4 = ++i;
            column.setRadix(rs.getInt(n4));
            int n5 = ++i;
            column.setNullable(MetaDataJavaUtil.decodeNullable(rs.getInt(n5)));
            int n6 = ++i;
            column.setRemarks(rs.getString(n6));
            int n7 = ++i;
            ++i;
            column.setDefaultValue(rs.getString(n7));
            ++i;
            int n8 = ++i;
            column.setCharOctetLength(rs.getInt(n8));
            int n9 = ++i;
            column.setOrdinalPosition(rs.getInt(n9));
            int n10 = ++i;
            ++i;
            column.setIsNullable(rs.getString(n10));
            if (!new SqlUtil(this.connection).isOracle()) {
                column.setScopeCatalog(rs.getString(i++));
                column.setScopeSchema(rs.getString(i++));
                column.setScopeTable(rs.getString(i++));
            }
            columns.add(column);
        }
        return columns;
    }

    public Table getTable(String tableName) throws SQLException {
        Objects.requireNonNull(tableName, "tableName cannot be null!");
        if (!this.tableNamesSet.contains(tableName.toLowerCase())) {
            throw new IllegalArgumentException("table does not exists: " + tableName);
        }
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        ResultSet rs = databaseMetaData.getTables(this.catalog, this.schema, tableName, null);
        Table table = new Table();
        while (rs.next()) {
            if (!rs.getString(3).equalsIgnoreCase(tableName)) continue;
            int i = 1;
            table.setCatalog(rs.getString(i++));
            table.setSchema(rs.getString(i++));
            table.setTableName(rs.getString(i++));
            table.setTableType(rs.getString(i++));
            table.setRemarks(rs.getString(i++));
            List<Column> columns = this.getColumns(tableName);
            List<PrimaryKey> primaryKeys = this.getPrimaryKeys(tableName);
            List<Index> indexes = this.getIndexes(tableName);
            List<ImportedKey> importedKeys = this.getImportedKeys(tableName);
            List<ExportedKey> exportedKeys = this.getExportedKeys(tableName);
            table.setColumns(columns);
            table.setPrimaryKeys(primaryKeys);
            table.setIndexes(indexes);
            table.setImportedforeignKeys(importedKeys);
            table.setExportedforeignKeys(exportedKeys);
        }
        return table;
    }

    private void debug(String string) {
        if (DEBUG) {
            System.out.println(new Date() + " " + string);
        }
    }
}

