/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.metadata.dto;

import java.sql.SQLException;
import java.util.Objects;
import org.kawanfw.sql.metadata.dto.DatabaseInfoDto;

public class DatabaseInfo {
    private int datatabaseMajorVersion;
    private int databaseMinorVersion;
    private String databaseProductName;
    private String databaseProductVersion;
    private int driverMajorVersion;
    private int driverMinorVersion;
    private String driverName;
    private String driverVersion;

    DatabaseInfo(DatabaseInfoDto databaseMetaData) throws SQLException {
        Objects.requireNonNull(databaseMetaData, "databaseMetaData cannot be null!");
        this.datatabaseMajorVersion = databaseMetaData.getDatatabaseMajorVersion();
        this.databaseMinorVersion = databaseMetaData.getDatabaseMinorVersion();
        this.databaseProductName = databaseMetaData.getDatabaseProductName();
        this.databaseProductVersion = databaseMetaData.getDatabaseProductVersion();
        this.driverMajorVersion = databaseMetaData.getDriverMajorVersion();
        this.driverMinorVersion = databaseMetaData.getDriverMinorVersion();
        this.driverName = databaseMetaData.getDriverName();
        this.driverVersion = databaseMetaData.getDriverVersion();
    }

    public int getDatatabaseMajorVersion() {
        return this.datatabaseMajorVersion;
    }

    public int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public String toString() {
        return "DatabaseInfo [datatabaseMajorVersion=" + this.datatabaseMajorVersion + ", databaseMinorVersion=" + this.databaseMinorVersion + ", databaseProductName=" + this.databaseProductName + ", databaseProductVersion=" + this.databaseProductVersion + ", driverMajorVersion=" + this.driverMajorVersion + ", driverMinorVersion=" + this.driverMinorVersion + ", driverName=" + this.driverName + ", driverVersion=" + this.driverVersion + "]";
    }
}

