/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.metadata.dto;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Objects;

public class DatabaseInfoDto {
    private String status = "OK";
    private int datatabaseMajorVersion;
    private int databaseMinorVersion;
    private String databaseProductName;
    private String databaseProductVersion;
    private int driverMajorVersion;
    private int driverMinorVersion;
    private String driverName;
    private String driverVersion;

    public DatabaseInfoDto(DatabaseMetaData databaseMetaData) throws SQLException {
        Objects.requireNonNull(databaseMetaData, "databaseMetaData cannot be null!");
        try {
            this.datatabaseMajorVersion = databaseMetaData.getDatabaseMajorVersion();
        }
        catch (SQLException e) {
            this.datatabaseMajorVersion = 0;
        }
        try {
            this.databaseMinorVersion = databaseMetaData.getDatabaseMinorVersion();
        }
        catch (SQLException e) {
            this.databaseMinorVersion = 0;
        }
        try {
            this.databaseProductName = databaseMetaData.getDatabaseProductName();
        }
        catch (SQLException e) {
            this.databaseProductName = "unknown";
        }
        try {
            this.databaseProductVersion = databaseMetaData.getDatabaseProductVersion();
        }
        catch (SQLException e) {
            this.databaseProductVersion = "unknown";
        }
        try {
            this.driverMajorVersion = databaseMetaData.getDriverMajorVersion();
        }
        catch (Exception e) {
            this.driverMajorVersion = 0;
        }
        try {
            this.driverMinorVersion = databaseMetaData.getDriverMinorVersion();
        }
        catch (Exception e) {
            this.driverMinorVersion = 0;
        }
        try {
            this.driverName = databaseMetaData.getDriverName();
        }
        catch (SQLException e) {
            this.driverName = "unknown";
        }
        try {
            this.driverVersion = databaseMetaData.getDriverVersion();
        }
        catch (SQLException e) {
            this.driverVersion = "unknown";
        }
    }

    public String getStatus() {
        return this.status;
    }

    public int getDatatabaseMajorVersion() {
        return this.datatabaseMajorVersion;
    }

    public int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public String toString() {
        return "DatabaseInfoDto [status=" + this.status + ", datatabaseMajorVersion=" + this.datatabaseMajorVersion + ", databaseMinorVersion=" + this.databaseMinorVersion + ", databaseProductName=" + this.databaseProductName + ", databaseProductVersion=" + this.databaseProductVersion + ", driverMajorVersion=" + this.driverMajorVersion + ", driverMinorVersion=" + this.driverMinorVersion + ", driverName=" + this.driverName + ", driverVersion=" + this.driverVersion + "]";
    }
}

