/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.metadata.sc.info;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.kawanfw.sql.api.util.SqlUtil;
import org.kawanfw.sql.metadata.AceQLMetaData;
import org.kawanfw.sql.metadata.sc.info.AceQLOutputFormat;
import org.kawanfw.sql.metadata.util.FileWordReplacer;
import org.kawanfw.sql.version.VersionWrapper;
import schemacrawler.Version;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.RegularExpressionExclusionRule;
import schemacrawler.schemacrawler.RegularExpressionInclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.tools.executable.SchemaCrawlerExecutable;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import schemacrawler.tools.options.TextOutputFormat;

public class SchemaInfoSC {
    private Connection connection = null;
    private SchemaInfoLevel schemaInfoLevel = SchemaInfoLevelBuilder.standard();
    private String SC_NAME = "SchemaCrawler";
    private String SC_VERSION = Version.getVersion();
    private String ACEQL_NAME = "AceQL";
    private String ACEQL_VERSION = VersionWrapper.getVersionNumber();
    private Set<String> tableSet = new HashSet<String>();

    public SchemaInfoSC(Connection connection) throws SQLException {
        this.connection = Objects.requireNonNull(connection, "connection cannot be null!");
        AceQLMetaData aceQLMetaData = new AceQLMetaData(connection);
        List<String> tables = aceQLMetaData.getTableNames();
        for (String tableName : tables) {
            this.tableSet.add(tableName);
        }
    }

    public SchemaInfoSC(Connection connection, SchemaInfoLevel schemaInfoLevel) throws SQLException {
        this(connection);
        this.connection = connection;
        this.schemaInfoLevel = Objects.requireNonNull(schemaInfoLevel, "schemaInfoLevel cannot be null!");
    }

    public void buildOnFile(File file, AceQLOutputFormat outputFormat, String table) throws SQLException, IOException {
        Objects.requireNonNull(file, "file cannot be null!");
        if (table != null && !this.tableSet.contains(table.toLowerCase()) && !this.tableSet.contains(table.toUpperCase())) {
            throw new SQLException("table does not exist:" + table);
        }
        File temp = new File(String.valueOf(file.toString()) + ".tmp");
        AceQLOutputFormat outputFormatNew = outputFormat;
        if (outputFormatNew == null) {
            outputFormatNew = AceQLOutputFormat.html;
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(temp));){
            this.buildOnWriter(writer, outputFormat, table);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ArrayList<String> oldWords = new ArrayList<String>();
        ArrayList<String> newWords = new ArrayList<String>();
        oldWords.add(this.SC_NAME);
        oldWords.add(this.SC_VERSION);
        newWords.add(this.ACEQL_NAME);
        newWords.add(this.ACEQL_VERSION);
        FileWordReplacer fileWordReplacer = new FileWordReplacer(temp, file, oldWords, newWords);
        fileWordReplacer.replaceAll();
        temp.delete();
    }

    public void buildOnWriter(BufferedWriter writer, AceQLOutputFormat outputFormat, String table) throws SQLException, IOException {
        Pattern pattern;
        DatabaseMetaData databaseMetaData;
        SqlUtil sqlUtil;
        Objects.requireNonNull(writer, "writer cannot be null!");
        SchemaCrawlerOptionsBuilder optionsBuilder = SchemaCrawlerOptionsBuilder.builder().withSchemaInfoLevel(this.schemaInfoLevel);
        if (table != null) {
            optionsBuilder.tableNamePattern(table);
        }
        if ((sqlUtil = new SqlUtil(this.connection)).isMySQL()) {
            Pattern pattern2 = Pattern.compile("mysql|performance_schema", 2);
            optionsBuilder.includeSchemas((InclusionRule)new RegularExpressionExclusionRule(pattern2));
        }
        if (sqlUtil.isSQLServer()) {
            databaseMetaData = this.connection.getMetaData();
            String databaseName = SchemaInfoSC.getSqlServerDatabaseName(databaseMetaData);
            pattern = Pattern.compile(String.valueOf(databaseName) + ".dbo", 2);
            optionsBuilder.includeSchemas((InclusionRule)new RegularExpressionInclusionRule(pattern));
        }
        if (sqlUtil.isDB2() || sqlUtil.isOracle()) {
            databaseMetaData = this.connection.getMetaData();
            String schema = databaseMetaData.getUserName();
            pattern = Pattern.compile(schema, 2);
            optionsBuilder.includeSchemas((InclusionRule)new RegularExpressionInclusionRule(pattern));
        }
        SchemaCrawlerOptions options = optionsBuilder.toOptions();
        OutputFormat outputFormatSC = SchemaInfoSC.getOutputFormatFromAceQL(outputFormat);
        OutputOptions outputOptions = OutputOptionsBuilder.builder().withOutputFormat(outputFormatSC).withOutputWriter((Writer)writer).toOptions();
        String command = "schema";
        SchemaCrawlerExecutable executable = new SchemaCrawlerExecutable("schema");
        executable.setSchemaCrawlerOptions(options);
        executable.setOutputOptions(outputOptions);
        executable.setConnection(this.connection);
        try {
            executable.execute();
        }
        catch (IOException ioException) {
            throw ioException;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    private static String getSqlServerDatabaseName(DatabaseMetaData databaseMetaData) throws SQLException {
        String[] urlElements;
        Objects.requireNonNull(databaseMetaData, "databaseMetaData cannot be null!");
        String databaseName = null;
        String[] stringArray = urlElements = databaseMetaData.getURL().split(";");
        int n = urlElements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.contains("databaseName=")) {
                databaseName = StringUtils.substringAfter((String)element, (String)"databaseName=");
                break;
            }
            ++n2;
        }
        return databaseName;
    }

    private static OutputFormat getOutputFormatFromAceQL(AceQLOutputFormat outputFormat) {
        if (outputFormat.equals((Object)AceQLOutputFormat.html)) {
            return TextOutputFormat.html;
        }
        return TextOutputFormat.text;
    }
}

