/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.metadata.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class FileWordReplacer {
    private static String CR_LF = System.getProperty("line.separator");
    private File inFile = null;
    private File outFile = null;
    private List<String> oldWords = new ArrayList<String>();
    private List<String> newWords = new ArrayList<String>();

    public FileWordReplacer(File inFile, File outFile, List<String> oldWords, List<String> newWords) throws FileNotFoundException {
        this.inFile = Objects.requireNonNull(inFile, "inFile cannot be null!");
        this.outFile = Objects.requireNonNull(outFile, "outFile cannot be null!");
        this.oldWords = Objects.requireNonNull(oldWords, "oldWords cannot be null!");
        this.newWords = Objects.requireNonNull(newWords, "newWords cannot be null!");
        if (!inFile.exists()) {
            throw new FileNotFoundException("inFile does not exist: " + inFile);
        }
        if (oldWords.size() != newWords.size()) {
            throw new IllegalArgumentException("oldWords & newWords sizes are different!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void replaceAll() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.inFile));
            try {
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.outFile));){
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        int i = 0;
                        while (i < this.oldWords.size()) {
                            line = line.replace(this.oldWords.get(i), this.newWords.get(i));
                            ++i;
                        }
                        writer.write(String.valueOf(line) + CR_LF);
                    }
                }
                if (br == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (br == null) throw throwable;
                br.close();
                throw throwable;
            }
            br.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println(new Date() + " Begin...");
        File inFile = new File("c:\\test\\sc.out.html");
        File outFile = new File("c:\\test\\sc.out-2.html");
        ArrayList<String> oldWords = new ArrayList<String>();
        ArrayList<String> newWords = new ArrayList<String>();
        oldWords.add("SchemaCrawler");
        oldWords.add("16.2.7");
        newWords.add("AceQL");
        newWords.add("4.0");
        FileWordReplacer fileWordReplacer = new FileWordReplacer(inFile, outFile, oldWords, newWords);
        fileWordReplacer.replaceAll();
        System.out.println(new Date() + " Done.");
    }
}

