/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.servlet.BlobDownloader;
import org.kawanfw.sql.servlet.BlobLengthGetter;
import org.kawanfw.sql.servlet.ServerLoginActionSql;
import org.kawanfw.sql.servlet.ServerLogout;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.connection.ConnectionIdUtil;
import org.kawanfw.sql.servlet.connection.ConnectionStore;
import org.kawanfw.sql.servlet.connection.RollbackUtil;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.injection.properties.ConfPropertiesUtil;
import org.kawanfw.sql.servlet.sql.json_return.JsonErrorReturn;
import org.kawanfw.sql.servlet.sql.json_return.JsonOkReturn;
import org.kawanfw.sql.util.FrameworkDebug;

public class BaseActionTreater {
    private static boolean DEBUG = FrameworkDebug.isSet(BaseActionTreater.class);
    private HttpServletRequest request;
    private HttpServletResponse response;
    private DatabaseConfigurator databaseConfigurator;
    private OutputStream out;

    public BaseActionTreater(HttpServletRequest request, HttpServletResponse response, OutputStream out) {
        this.request = request;
        this.response = response;
        this.out = out;
    }

    public boolean treatAndContinue() throws IOException, SQLException {
        String action = this.request.getParameter("action");
        String username = this.request.getParameter("username");
        String database = this.request.getParameter("database");
        String sessionId = this.request.getParameter("session_id");
        if (this.isActionNullOrEmpty(action)) {
            return false;
        }
        if (this.isActionLogin(action)) {
            return false;
        }
        if (this.isDatabaseConfiguratorNull(database)) {
            return false;
        }
        if (this.isActionGetConnection(action, username, database, sessionId)) {
            return false;
        }
        if (this.isActiobBlobUpload(action, username)) {
            return false;
        }
        if (this.isActionDownload(action, username)) {
            return false;
        }
        if (action.equals("logout") || action.equals("disconnect")) {
            ServerLogout.logout(this.request, this.response, this.out, this.databaseConfigurator);
            return false;
        }
        return true;
    }

    private boolean isActionDownload(String action, String username) throws IOException, SQLException {
        if (action.equals("get_blob_length")) {
            BlobLengthGetter blobLengthGetter = new BlobLengthGetter(this.request, this.response, this.out, username, this.databaseConfigurator);
            blobLengthGetter.getLength();
            return true;
        }
        return false;
    }

    private boolean isActiobBlobUpload(String action, String username) throws IOException, SQLException {
        if (action.equals("blob_download")) {
            BlobDownloader blobDownloader = new BlobDownloader(this.request, this.response, this.out, username, this.databaseConfigurator);
            blobDownloader.blobDownload();
            return true;
        }
        return false;
    }

    private boolean isActionGetConnection(String action, String username, String database, String sessionId) throws SQLException, IOException {
        if (action.equals("get_connection")) {
            BaseActionTreater.debug(new Date() + " /get_connection called!");
            if (ConfPropertiesUtil.isStatelessMode()) {
                ServerSqlManager.writeLine(this.out, JsonOkReturn.build("connection_id", ConnectionIdUtil.getStatelessConnectionId()));
                return true;
            }
            Connection connection = null;
            try {
                connection = this.databaseConfigurator.getConnection(database);
                String connectionIdNew = ConnectionIdUtil.getConnectionId(connection);
                ConnectionStore connectionStore = new ConnectionStore(username, sessionId, connectionIdNew);
                connectionStore.put(connection);
                ServerSqlManager.writeLine(this.out, JsonOkReturn.build("connection_id", connectionIdNew));
                return true;
            }
            catch (Exception e) {
                RollbackUtil.rollback(connection);
                throw e;
            }
        }
        return false;
    }

    private boolean isDatabaseConfiguratorNull(String database) throws IOException {
        this.databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(database);
        if (this.databaseConfigurator == null) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 400, 2, "Database does not exist: " + database);
            ServerSqlManager.writeLine(this.out, errorReturn.build());
            return true;
        }
        return false;
    }

    private boolean isActionLogin(String action) throws IOException {
        if (action.equals("login") || action.equals("connect")) {
            ServerLoginActionSql serverLoginActionSql = new ServerLoginActionSql();
            serverLoginActionSql.executeAction(this.request, this.response, this.out, action);
            return true;
        }
        return false;
    }

    private boolean isActionNullOrEmpty(String action) throws IOException {
        if (action == null || action.isEmpty()) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 400, 2, "No action found in request.");
            ServerSqlManager.writeLine(this.out, errorReturn.build());
            return true;
        }
        return false;
    }

    public DatabaseConfigurator getDatabaseConfigurator() {
        return this.databaseConfigurator;
    }

    public static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

