/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.blob.BlobDownloadConfigurator;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.sql.LoggerUtil;
import org.kawanfw.sql.servlet.sql.json_return.JsonErrorReturn;

public class BlobDownloader {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String username;
    private DatabaseConfigurator databaseConfigurator;
    private OutputStream out;

    public BlobDownloader(HttpServletRequest request, HttpServletResponse response, OutputStream out, String username, DatabaseConfigurator databaseConfigurator) {
        this.request = request;
        this.response = response;
        this.out = out;
        this.username = username;
        this.databaseConfigurator = databaseConfigurator;
    }

    public void blobDownload() throws IOException, SQLException {
        String blobId = this.request.getParameter("blob_id");
        File blobDirectory = this.databaseConfigurator.getBlobsDirectory(this.username);
        if (blobDirectory != null && !blobDirectory.exists()) {
            blobDirectory.mkdirs();
        }
        if (blobDirectory == null || !blobDirectory.exists()) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 404, 2, "Blob directory defined in DatabaseConfigurator.getBlobDirectory() does not exist: " + blobDirectory.getName());
            ServerSqlManager.writeLine(this.out, errorReturn.build());
            return;
        }
        String fileName = String.valueOf(this.databaseConfigurator.getBlobsDirectory(this.username).toString()) + File.separator + blobId;
        File file = new File(fileName);
        if (!file.exists()) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 404, 2, "Invalid blob_id. No Blob corresponding to blob_id: " + blobId);
            ServerSqlManager.writeLine(this.out, errorReturn.build());
            return;
        }
        try {
            BlobDownloadConfigurator BlobDownloader2 = InjectedClassesStore.get().getBlobDownloadConfigurator();
            BlobDownloader2.download(this.request, file, this.out);
        }
        catch (Exception e) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 500, 2, "An error occurred during Blob download: " + e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            ServerSqlManager.writeLine(this.out, errorReturn.build());
            LoggerUtil.log(this.request, e);
        }
    }
}

