/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.sql.json_return.JsonErrorReturn;
import org.kawanfw.sql.servlet.sql.json_return.JsonOkReturn;
import org.kawanfw.sql.servlet.util.BlobUtil;

public class BlobLengthGetter {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private OutputStream out;
    private String username;
    private DatabaseConfigurator databaseConfigurator;

    public BlobLengthGetter(HttpServletRequest request, HttpServletResponse response, OutputStream out, String username, DatabaseConfigurator databaseConfigurator) {
        this.request = request;
        this.response = response;
        this.out = out;
        this.username = username;
        this.databaseConfigurator = databaseConfigurator;
    }

    public void getLength() throws IOException, SQLException {
        String blobId = this.request.getParameter("blob_id");
        long length = -1L;
        File blobDirectory = this.databaseConfigurator.getBlobsDirectory(this.username);
        if (blobDirectory != null && !blobDirectory.exists()) {
            blobDirectory.mkdirs();
        }
        if (blobDirectory == null || !blobDirectory.exists()) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 404, 2, "Blob directory defined in DatabaseConfigurator.getBlobDirectory() does not exist: " + blobDirectory.getName());
            ServerSqlManager.writeLine(this.out, errorReturn.build());
            return;
        }
        try {
            length = BlobUtil.getBlobLength(blobId, blobDirectory);
        }
        catch (Exception e) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 404, 2, "Invalid blob_id. No Blob corresponding to blob_id: " + blobId);
            ServerSqlManager.writeLine(this.out, errorReturn.build());
            return;
        }
        ServerSqlManager.writeLine(this.out, JsonOkReturn.build("length", String.valueOf(length)));
    }
}

