/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tomcat.util.http.fileupload.FileUploadException;
import org.apache.tomcat.util.http.fileupload.impl.FileUploadIOException;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.blob.BlobUploadConfigurator;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.sql.LoggerUtil;
import org.kawanfw.sql.servlet.sql.json_return.JsonErrorReturn;
import org.kawanfw.sql.servlet.sql.json_return.JsonOkReturn;
import org.kawanfw.sql.util.Tag;

public class BlobUploader {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private OutputStream out;

    public BlobUploader(HttpServletRequest request, HttpServletResponse response, OutputStream out) {
        this.request = request;
        this.response = response;
        this.out = out;
    }

    public void blobUpload() throws IOException, FileUploadException, SQLException {
        String username = this.request.getParameter("username");
        String database = this.request.getParameter("database");
        DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(database);
        File blobDirectory = databaseConfigurator.getBlobsDirectory(username);
        if (blobDirectory != null && !blobDirectory.exists()) {
            blobDirectory.mkdirs();
        }
        if (blobDirectory == null || !blobDirectory.exists()) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 404, 2, "Blob directory defined in DatabaseConfigurator.getBlobDirectory() does not exist: " + blobDirectory.getName());
            ServerSqlManager.writeLine(this.out, errorReturn.build());
            return;
        }
        try {
            long maxBlobLength = databaseConfigurator.getMaxBlobLength(username, database);
            BlobUploadConfigurator blobUploadConfigurator = InjectedClassesStore.get().getBlobUploadConfigurator();
            try {
                blobUploadConfigurator.upload(this.request, this.response, blobDirectory, maxBlobLength);
            }
            catch (FileUploadIOException e) {
                throw new IOException(String.valueOf(Tag.PRODUCT_SECURITY) + " Blob length exceeds maximum permitted size of " + maxBlobLength + " bytes.");
            }
            ServerSqlManager.writeLine(this.out, JsonOkReturn.build());
        }
        catch (Exception e) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 500, 2, "An error occurred during Blob upload: " + e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            ServerSqlManager.writeLine(this.out, errorReturn.build());
            LoggerUtil.log(this.request, e);
        }
    }
}

