/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.kawanfw.sql.util.FrameworkDebug;

public class JavaValueBuilder {
    private static boolean DEBUG = FrameworkDebug.isSet(JavaValueBuilder.class);
    private String javaType = null;
    private String stringValue = null;
    private Class<?> classOfValue = null;
    private Object value = null;

    public JavaValueBuilder(String javaType, String stringValue) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.javaType = javaType;
        this.stringValue = stringValue;
        this.decode();
    }

    private void decode() throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.javaType.endsWith("null")) {
            this.classOfValue = Object.class;
            this.value = null;
        } else if (this.javaType.endsWith("BigDecimal")) {
            this.classOfValue = BigDecimal.class;
            this.value = new BigDecimal(this.stringValue);
        } else if (this.javaType.endsWith("Boolean")) {
            this.classOfValue = Boolean.TYPE;
            this.value = Boolean.valueOf(this.stringValue);
        } else if (this.javaType.endsWith("Date")) {
            this.classOfValue = Date.class;
            this.value = Date.valueOf(this.stringValue);
        } else if (this.javaType.endsWith("Double")) {
            this.classOfValue = Double.TYPE;
            this.value = new Double(this.stringValue);
        } else if (this.javaType.endsWith("Float")) {
            this.classOfValue = Float.TYPE;
            this.value = new Float(this.stringValue);
        } else if (this.javaType.endsWith("Integer")) {
            this.classOfValue = Integer.TYPE;
            this.value = new Integer(this.stringValue);
        } else if (this.javaType.endsWith("Long")) {
            this.classOfValue = Long.TYPE;
            this.value = new Long(this.stringValue);
        } else if (this.javaType.endsWith("Object")) {
            this.classOfValue = Object.class;
            this.value = this.stringValue;
        } else if (this.javaType.endsWith("Short")) {
            this.classOfValue = Short.TYPE;
            this.value = new Short(this.stringValue);
        } else if (this.javaType.endsWith("String")) {
            this.classOfValue = String.class;
            this.value = this.stringValue;
        } else if (this.javaType.endsWith("Time")) {
            this.classOfValue = Date.class;
            this.value = Time.valueOf(this.stringValue);
        } else if (this.javaType.endsWith("Timestamp")) {
            this.classOfValue = Date.class;
            this.value = Timestamp.valueOf(this.stringValue);
        } else {
            JavaValueBuilder.debug("javaType   : " + this.javaType + ":");
            JavaValueBuilder.debug("stringValue: " + this.stringValue + ":");
            Class<?> paramClass = Class.forName(this.javaType);
            Constructor<?> ctor = paramClass.getDeclaredConstructor(String.class);
            ctor.setAccessible(true);
            Object o = ctor.newInstance(this.stringValue);
            this.classOfValue = paramClass;
            this.value = o;
        }
    }

    public Class<?> getClassOfValue() {
        return this.classOfValue;
    }

    public Object getValue() {
        return this.value;
    }

    public static void debug(String s) {
        if (DEBUG) {
            System.out.println(new java.util.Date() + " " + s);
        }
    }
}

