/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.kawanfw.sql.api.server.SqlEventWrapper;
import org.kawanfw.sql.api.server.firewall.SqlFirewallManager;
import org.kawanfw.sql.api.util.firewall.SqlFirewallTriggerWrapper;
import org.kawanfw.sql.metadata.AceQLMetaData;
import org.kawanfw.sql.metadata.dto.JdbcDatabaseMetaDataDto;
import org.kawanfw.sql.metadata.dto.TableDto;
import org.kawanfw.sql.metadata.dto.TableNamesDto;
import org.kawanfw.sql.metadata.util.GsonWsUtil;
import org.kawanfw.sql.servlet.MetadataQuerySchemaDownloader;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.connection.RollbackUtil;
import org.kawanfw.sql.servlet.sql.ServerStatementUtil;
import org.kawanfw.sql.servlet.sql.json_return.JsonErrorReturn;
import org.kawanfw.sql.servlet.sql.json_return.JsonSecurityMessage;
import org.kawanfw.sql.servlet.util.healthcheck.HealthCheckInfoDto;
import org.kawanfw.sql.util.IpUtil;

public class MetadataQueryActionManager {
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private Connection connection = null;
    Set<SqlFirewallManager> sqlFirewallManagers = new LinkedHashSet<SqlFirewallManager>();
    private OutputStream out = null;

    public MetadataQueryActionManager(HttpServletRequest request, HttpServletResponse response, OutputStream out, Set<SqlFirewallManager> sqlFirewallManagers, Connection connection) {
        this.request = request;
        this.response = response;
        this.out = out;
        this.sqlFirewallManagers = sqlFirewallManagers;
        this.connection = connection;
    }

    public void execute() throws SQLException, IOException {
        try {
            this.executeInTryCatch(this.out);
        }
        catch (SecurityException e) {
            RollbackUtil.rollback(this.connection);
            JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 403, 3, e.getMessage());
            ServerSqlManager.writeLine(this.out, errorReturn.build());
        }
        catch (SQLException e) {
            RollbackUtil.rollback(this.connection);
            JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 400, 1, e.getMessage());
            ServerSqlManager.writeLine(this.out, errorReturn.build());
        }
        catch (Exception e) {
            RollbackUtil.rollback(this.connection);
            JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 500, 4, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            ServerSqlManager.writeLine(this.out, errorReturn.build());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void executeInTryCatch(OutputStream out) throws SQLException, IOException, SecurityException, FileNotFoundException, IllegalArgumentException {
        block10: {
            block11: {
                block9: {
                    aceQLMetaData = new AceQLMetaData(this.connection);
                    action = this.request.getParameter("action");
                    username = this.request.getParameter("username");
                    database = this.request.getParameter("database");
                    allow = true;
                    sql = "<void>";
                    for (SqlFirewallManager sqlFirewallManager : this.sqlFirewallManagers) {
                        allow = sqlFirewallManager.allowMetadataQuery(username, database, this.connection);
                        if (allow) continue;
                        ipAddress = IpUtil.getRemoteAddr(this.request);
                        parameterValues = new ArrayList<Object>();
                        sqlEvent = SqlEventWrapper.sqlEventBuild(username, database, ipAddress, sql, ServerStatementUtil.isPreparedStatement(this.request), parameterValues, true);
                        SqlFirewallTriggerWrapper.runIfStatementRefused(sqlEvent, sqlFirewallManager, this.connection);
                        break;
                    }
                    if (!allow) {
                        parameters = new HashMap<Integer, String>();
                        values = new ArrayList<Object>();
                        message = JsonSecurityMessage.prepStatementNotAllowedBuild(sql, "Metadata Query API calls are not allowed!", parameters, values, true);
                        throw new SecurityException(message);
                    }
                    if (!action.equals("metadata_query_db_schema_download")) break block9;
                    metadataQuerySchemaDownloader = new MetadataQuerySchemaDownloader(this.request, this.response, out, this.connection, aceQLMetaData);
                    metadataQuerySchemaDownloader.schemaDowload();
                    break block10;
                }
                if (!action.equals("metadata_query_get_db_metadata")) break block11;
                jdbcDatabaseMetaData = aceQLMetaData.getJdbcDatabaseMetaData();
                jdbcDatabaseMetaDataDto = new JdbcDatabaseMetaDataDto(jdbcDatabaseMetaData);
                jsonString = GsonWsUtil.getJSonString(jdbcDatabaseMetaDataDto);
                this.response.setContentType("text/plain");
                ServerSqlManager.writeLine(out, jsonString);
                break block10;
            }
            if (!action.equals("metadata_query_get_table_details")) ** GOTO lbl51
            tableName = this.request.getParameter("table_name");
            this.response.setContentType("text/plain");
            tables = new HashSet<String>();
            theTableNames = aceQLMetaData.getTableNames();
            for (String theTableName : theTableNames) {
                tables.add(theTableName.toLowerCase());
            }
            if (tableName != null && tables.contains(tableName.toLowerCase())) {
                table = aceQLMetaData.getTable(tableName);
                tableDto = new TableDto(table);
                jsonString = GsonWsUtil.getJSonString(tableDto);
                ServerSqlManager.writeLine(out, jsonString);
            } else {
                errorReturn = new JsonErrorReturn(this.response, 400, 2, "SQL table not found in database.");
                ServerSqlManager.writeLine(out, errorReturn.build());
                return;
lbl51:
                // 1 sources

                if (action.equals("metadata_query_get_table_names")) {
                    tableType = this.request.getParameter("table_type");
                    tableNames /* !! */  = new ArrayList<E>();
                    tableNames /* !! */  = tableType == null || tableType.isEmpty() != false ? aceQLMetaData.getTableNames() : aceQLMetaData.getTableNames(tableType);
                    tableNamesDto = new TableNamesDto(tableNames /* !! */ );
                    jsonString = GsonWsUtil.getJSonString(tableNamesDto);
                    this.response.setContentType("text/plain");
                    ServerSqlManager.writeLine(out, jsonString);
                } else if (action.equals("health_check_info")) {
                    healthCheckInfoDto = new HealthCheckInfoDto();
                    jsonString = GsonWsUtil.getJSonString(healthCheckInfoDto);
                    this.response.setContentType("text/plain");
                    ServerSqlManager.writeLine(out, jsonString);
                } else {
                    throw new IllegalArgumentException("Unknown metadata_query action: " + action);
                }
            }
        }
    }
}

