/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.kawanfw.sql.api.util.SqlUtil;
import org.kawanfw.sql.metadata.AceQLMetaData;
import org.kawanfw.sql.metadata.sc.info.AceQLOutputFormat;
import org.kawanfw.sql.metadata.sc.info.SchemaInfoAccessor;
import org.kawanfw.sql.metadata.sc.info.SchemaInfoSC;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.sql.json_return.JsonErrorReturn;

public class MetadataQuerySchemaDownloader {
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private Connection connection = null;
    private AceQLMetaData aceQLMetaData = null;
    private OutputStream out;

    public MetadataQuerySchemaDownloader(HttpServletRequest request, HttpServletResponse response, OutputStream out, Connection connection, AceQLMetaData aceQLMetaData) {
        this.request = request;
        this.response = response;
        this.out = out;
        this.connection = connection;
        this.aceQLMetaData = aceQLMetaData;
    }

    public void schemaDowload() throws IOException, SQLException, FileNotFoundException {
        SqlUtil sqlUtil = new SqlUtil(this.connection);
        if (sqlUtil.isOracle()) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 400, 2, "SchemaCrawler schema generation is not supported with Oracle Database in this AceQL version.");
            ServerSqlManager.writeLine(this.out, errorReturn.build());
            return;
        }
        String format = this.request.getParameter("format");
        String tableName = this.request.getParameter("table_name");
        AceQLOutputFormat aceQLOutputFormat = null;
        if (format == null || format.isEmpty()) {
            format = AceQLOutputFormat.html.toString();
        }
        if (format.contentEquals(AceQLOutputFormat.html.toString())) {
            aceQLOutputFormat = AceQLOutputFormat.html;
        } else if (format.contentEquals(AceQLOutputFormat.text.toString())) {
            aceQLOutputFormat = AceQLOutputFormat.text;
        } else {
            JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 400, 2, "The output format is invalid. Should be \"html\" or \"text\".");
            ServerSqlManager.writeLine(this.out, errorReturn.build());
            return;
        }
        SchemaInfoAccessor schemaInfoAccessor = new SchemaInfoAccessor(this.connection);
        if (!this.checkBaseValues(tableName, schemaInfoAccessor)) {
            return;
        }
        this.buildSchema(tableName, aceQLOutputFormat, schemaInfoAccessor);
    }

    private void buildSchema(String tableName, AceQLOutputFormat aceQLOutputFormat, SchemaInfoAccessor schemaInfoAccessor) throws SQLException, IOException, FileNotFoundException {
        SchemaInfoSC schemaInfoSC = schemaInfoAccessor.getSchemaInfoSC();
        File tempFile = File.createTempFile("sc_output", null);
        schemaInfoSC.buildOnFile(tempFile, aceQLOutputFormat, tableName);
        String type = aceQLOutputFormat == AceQLOutputFormat.html ? "text/html" : "text/plain";
        this.response.setContentType(type);
        Throwable throwable = null;
        Object var8_9 = null;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(tempFile));){
            IOUtils.copy((InputStream)in, (OutputStream)this.out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean checkBaseValues(String tableName, SchemaInfoAccessor schemaInfoAccessor) throws SQLException, IOException {
        if (tableName != null && !MetadataQuerySchemaDownloader.exists(this.aceQLMetaData, tableName)) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 400, 2, "SQL table not found in database.");
            ServerSqlManager.writeLine(this.out, errorReturn.build());
            return false;
        }
        if (!schemaInfoAccessor.isAccessible()) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 400, 4, schemaInfoAccessor.getFailureReason());
            ServerSqlManager.writeLine(this.out, errorReturn.build());
            return false;
        }
        return true;
    }

    private static boolean exists(AceQLMetaData aceQLMetaData, String tableName) throws SQLException {
        List<String> tableNames = aceQLMetaData.getTableNames();
        for (String theTableName : tableNames) {
            if (!theTableName.contains(tableName.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

