/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet;

import java.io.IOException;
import java.util.concurrent.RejectedExecutionException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kawanfw.sql.servlet.AsyncDebug;
import org.kawanfw.sql.servlet.sql.LoggerUtil;

public class ServerAsyncListener
implements AsyncListener {
    public void onStartAsync(AsyncEvent event) throws IOException {
    }

    public void onComplete(AsyncEvent event) throws IOException {
    }

    public void onError(AsyncEvent event) throws IOException {
        AsyncDebug.debug("ASYNC ERROR:" + event.getThrowable());
        if (AsyncDebug.DEBUG) {
            event.getThrowable().printStackTrace(System.out);
        }
        HttpServletRequest request = (HttpServletRequest)event.getSuppliedRequest();
        HttpServletResponse response = (HttpServletResponse)event.getSuppliedResponse();
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException ioexception) {
            AsyncDebug.debug("1 Internal IOException: " + ioexception.toString());
            response.setStatus(500);
            return;
        }
        if (out == null) {
            System.out.println(String.valueOf(AsyncDebug.getNowFormatted()) + " " + "2 Internal: out is null!");
            response.setStatus(500);
            LoggerUtil.log(request, event.getThrowable());
            return;
        }
        if (event.getThrowable() instanceof RejectedExecutionException) {
            AsyncDebug.debug("set reponse status to SC_SERVICE_UNAVAILABLE");
            response.setStatus(503);
            String message = "Server is too busy and not available for now. Please try later.";
            out.write(("<font face=\"arial\"><h3>" + message + "</h3>").getBytes());
            LoggerUtil.log(request, event.getThrowable());
        } else {
            AsyncDebug.debug("Set reponse status to SC_INTERNAL_SERVER_ERROR");
            response.setStatus(500);
            String message = "Server is on error and not available. Please try later.";
            out.write(("<font face=\"arial\"><h3>" + message + "</h3>").getBytes());
            LoggerUtil.log(request, event.getThrowable());
        }
    }

    public void onTimeout(AsyncEvent event) throws IOException {
        HttpServletRequest request = (HttpServletRequest)event.getSuppliedRequest();
        LoggerUtil.log(request, event.getThrowable());
        HttpServletResponse response = (HttpServletResponse)event.getSuppliedResponse();
        AsyncDebug.debug("Set reponse status to SC_GATEWAY_TIMEOUT");
        response.setStatus(504);
    }
}

