/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.auth.UserAuthenticator;
import org.kawanfw.sql.api.server.session.SessionConfigurator;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.Trace;
import org.kawanfw.sql.servlet.connection.ConnectionIdUtil;
import org.kawanfw.sql.servlet.connection.ConnectionStore;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.injection.properties.ConfPropertiesUtil;
import org.kawanfw.sql.servlet.sql.json_return.ExceptionReturner;
import org.kawanfw.sql.servlet.sql.json_return.JsonErrorReturn;
import org.kawanfw.sql.servlet.sql.json_return.JsonOkReturn;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.IpUtil;

public class ServerLoginActionSql
extends HttpServlet {
    public static boolean DEBUG = FrameworkDebug.isSet(ServerLoginActionSql.class);
    private static final long serialVersionUID = 1L;
    public static final String SPACE = " ";

    public void executeAction(HttpServletRequest request, HttpServletResponse response, OutputStream out, String action) throws IOException {
        try {
            response.setContentType("text/html");
            this.debug("before request.getParameter(HttpParameter.LOGIN);");
            String username = request.getParameter("username");
            String password = request.getParameter("password");
            if (!this.checkCredentialsAreSet(username, password)) {
                JsonErrorReturn errorReturn = new JsonErrorReturn(response, 401, 2, "Invalid username or password.");
                ServerSqlManager.writeLine(out, errorReturn.build());
                return;
            }
            username = username.trim();
            password = password.trim();
            this.debug("calling login");
            UserAuthenticator userAuthenticator = InjectedClassesStore.get().getUserAuthenticator();
            String database = request.getParameter("database");
            DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(database);
            if (databaseConfigurator == null) {
                JsonErrorReturn errorReturn = new JsonErrorReturn(response, 400, 2, "Database does not exist: " + database);
                ServerSqlManager.writeLine(out, errorReturn.build());
                return;
            }
            String ipAddress = IpUtil.getRemoteAddr(request);
            boolean isOk = false;
            isOk = userAuthenticator != null ? userAuthenticator.login(username, password.toCharArray(), database, ipAddress) : true;
            this.debug("login isOk: " + isOk + " (login: " + username + ")");
            if (!isOk) {
                this.debug("login: invalid login or password");
                JsonErrorReturn errorReturn = new JsonErrorReturn(response, 401, 2, "Invalid username or password.");
                ServerSqlManager.writeLine(out, errorReturn.build());
                return;
            }
            this.debug("Login done!");
            SessionConfigurator sessionConfigurator = InjectedClassesStore.get().getSessionConfigurator();
            String sessionId = sessionConfigurator.generateSessionId(username, database);
            String connectionId = null;
            if (ConfPropertiesUtil.isStatelessMode()) {
                connectionId = ConnectionIdUtil.getStatelessConnectionId();
            } else {
                Connection connection = databaseConfigurator.getConnection(database);
                connectionId = ConnectionIdUtil.getConnectionId(connection);
                ConnectionStore connectionStore = new ConnectionStore(username, sessionId, connectionId);
                connectionStore.put(connection);
            }
            Trace.sessionId("sessionId: " + sessionId);
            this.debug("sessionId: " + sessionId);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("session_id", sessionId);
            map.put("connection_id", connectionId);
            ServerSqlManager.writeLine(out, JsonOkReturn.build(map));
        }
        catch (Exception e) {
            ExceptionReturner.logAndReturnException(request, response, out, (Throwable)e);
        }
    }

    public boolean checkCredentialsAreSet(String username, String password) {
        return username != null && !username.isEmpty() && password != null && !password.isEmpty();
    }

    private void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + SPACE + s);
        }
    }
}

