/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.session.SessionConfigurator;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.connection.ConnectionStore;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.injection.properties.ConfPropertiesUtil;
import org.kawanfw.sql.servlet.sql.json_return.JsonErrorReturn;
import org.kawanfw.sql.servlet.sql.json_return.JsonOkReturn;
import org.kawanfw.sql.util.FrameworkDebug;

public class ServerLogout {
    private static boolean DEBUG = FrameworkDebug.isSet(ServerLogout.class);
    public static final String SPACE = " ";
    private static final long TWENTY_MINUTES_IN_MILLISECONDS = 1200000L;

    public static void logout(HttpServletRequest request, HttpServletResponse response, OutputStream out, DatabaseConfigurator databaseConfigurator) throws IOException {
        try {
            response.setContentType("text/html");
            String username = request.getParameter("username");
            String sessionId = request.getParameter("session_id");
            SessionConfigurator sessionConfigurator = InjectedClassesStore.get().getSessionConfigurator();
            sessionConfigurator.remove(sessionId);
            ServerLogout.deleteOldBlobFiles(databaseConfigurator, username);
            if (!ConfPropertiesUtil.isStatelessMode()) {
                Set<Connection> connections = ConnectionStore.getAllConnections(username, sessionId);
                for (Connection connection : connections) {
                    databaseConfigurator.close(connection);
                }
            }
            try {
                ConnectionStore.removeAll(username, sessionId);
            }
            catch (Exception e) {
                System.out.println(new Date() + " Failure on ConnectionStore.removeAll: " + e.toString());
            }
            String jSonReturn = JsonOkReturn.build();
            if (DEBUG) {
                System.err.println("jSonReturn: " + jSonReturn);
                System.err.println(sessionId);
            }
            ServerSqlManager.writeLine(out, jSonReturn);
        }
        catch (Exception e) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 500, 4, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            ServerSqlManager.writeLine(out, errorReturn.build());
        }
    }

    private static void deleteOldBlobFiles(DatabaseConfigurator databaseConfigurator, String username) throws IOException, SQLException {
        Objects.requireNonNull(databaseConfigurator, "databaseConfigurator cannot be null!");
        Objects.requireNonNull(username, "username cannot be null!");
        File blobDirectory = databaseConfigurator.getBlobsDirectory(username);
        if (blobDirectory == null || !blobDirectory.exists()) {
            return;
        }
        File[] files = blobDirectory.listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.lastModified() < System.currentTimeMillis() - 1200000L) {
                file.delete();
            }
            ++n2;
        }
    }
}

