/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tomcat.util.http.fileupload.FileUploadException;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.firewall.SqlFirewallManager;
import org.kawanfw.sql.metadata.dto.DatabaseInfoDto;
import org.kawanfw.sql.metadata.dto.LimitsInfoDto;
import org.kawanfw.sql.metadata.util.GsonWsUtil;
import org.kawanfw.sql.servlet.ActionUtil;
import org.kawanfw.sql.servlet.BaseActionTreater;
import org.kawanfw.sql.servlet.BlobUploader;
import org.kawanfw.sql.servlet.HttpParameter;
import org.kawanfw.sql.servlet.MetadataQueryActionManager;
import org.kawanfw.sql.servlet.ServerQueryExecutorUtil;
import org.kawanfw.sql.servlet.ServerSqlDispatchUtil;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.connection.ConnectionIdUtil;
import org.kawanfw.sql.servlet.connection.ConnectionStore;
import org.kawanfw.sql.servlet.connection.ConnectionStoreGetter;
import org.kawanfw.sql.servlet.connection.RollbackUtil;
import org.kawanfw.sql.servlet.connection.SavepointUtil;
import org.kawanfw.sql.servlet.connection.TransactionUtil;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.injection.properties.ConfPropertiesUtil;
import org.kawanfw.sql.servlet.jdbc.metadata.DefaultJdbcDatabaseMetadataActionManagerWrap;
import org.kawanfw.sql.servlet.sql.ServerStatement;
import org.kawanfw.sql.servlet.sql.ServerStatementRawExecute;
import org.kawanfw.sql.servlet.sql.batch.ServerPreparedStatementBatch;
import org.kawanfw.sql.servlet.sql.batch.ServerStatementBatch;
import org.kawanfw.sql.servlet.sql.callable.AdvancedServerCallableStatement;
import org.kawanfw.sql.servlet.sql.json_return.JsonErrorReturn;
import org.kawanfw.sql.servlet.sql.json_return.JsonOkReturn;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.version.VersionWrapper;

public class ServerSqlDispatch {
    private static final boolean DUMP_HEADERS = false;
    private static boolean DEBUG = FrameworkDebug.isSet(ServerSqlDispatch.class);

    public void executeRequestInTryCatch(HttpServletRequest request, HttpServletResponse response, OutputStream out) throws IOException, SQLException, FileUploadException {
        if (this.doBlobUpload(request, response, out)) {
            return;
        }
        response.setContentType("text/html; charset=UTF-8");
        String action = request.getParameter("action");
        String username = request.getParameter("username");
        String database = request.getParameter("database");
        String sessionId = request.getParameter("session_id");
        String connectionId = request.getParameter("connection_id");
        ServerSqlDispatch.debug("");
        ServerSqlDispatch.debug("action      : " + action);
        ServerSqlDispatch.debug("username    : " + username);
        ServerSqlDispatch.debug("database    : " + database);
        ServerSqlDispatch.debug("sessionId   : " + sessionId);
        ServerSqlDispatch.debug("connectionId: " + connectionId);
        BaseActionTreater baseActionTreater = new BaseActionTreater(request, response, out);
        if (!baseActionTreater.treatAndContinue()) {
            return;
        }
        DatabaseConfigurator databaseConfigurator = baseActionTreater.getDatabaseConfigurator();
        if (this.isGetVersion(out, action)) {
            return;
        }
        Connection connection = null;
        try {
            if (ConfPropertiesUtil.isStatelessMode()) {
                connection = databaseConfigurator.getConnection(database);
            } else {
                ConnectionStoreGetter connectionStoreGetter = new ConnectionStoreGetter(request, response);
                connection = connectionStoreGetter.getConnection();
                if (connectionStoreGetter.getJsonErrorReturn() != null) {
                    ServerSqlManager.writeLine(out, connectionStoreGetter.getJsonErrorReturn().build());
                    return;
                }
            }
            if (ServerSqlDispatchUtil.isUsernameBanned(username, database, connection)) {
                JsonErrorReturn errorReturn = new JsonErrorReturn(response, 403, 3, "Access Forbidden for Username");
                ServerSqlManager.writeLine(out, errorReturn.build());
                return;
            }
            if (ServerQueryExecutorUtil.isExecuteServerQuery(request, out, action, connection)) {
                return;
            }
            Set<SqlFirewallManager> sqlFirewallManagers = InjectedClassesStore.get().getSqlFirewallManagerMap().get(database);
            if (this.isGetDatabaseInfo(request, out, action, connection, sqlFirewallManagers)) {
                return;
            }
            if (this.isGetLimitsInfo(request, out, action, connection, sqlFirewallManagers, databaseConfigurator)) {
                return;
            }
            if (!this.checkStatelessInAutoCommit(request, response, out, connection)) {
                return;
            }
            if (action.equals("close")) {
                this.treatCloseAction(response, out, username, sessionId, connectionId, databaseConfigurator, connection);
                return;
            }
            if (this.doTreatJdbcDatabaseMetaData(request, response, out, action, connection, sqlFirewallManagers)) {
                return;
            }
            if (this.doTreatMetadataQuery(request, response, out, action, connection, sqlFirewallManagers)) {
                return;
            }
            try {
                this.dumpHeaders(request);
                this.dispatch(request, response, out, action, connection, databaseConfigurator, sqlFirewallManagers);
            }
            catch (Exception e) {
                RollbackUtil.rollback(connection);
                throw e;
            }
        }
        finally {
            if (ConfPropertiesUtil.isStatelessMode()) {
                databaseConfigurator.close(connection);
            }
        }
    }

    private boolean isGetDatabaseInfo(HttpServletRequest request, OutputStream out, String action, Connection connection, Set<SqlFirewallManager> sqlFirewallManagers) throws IOException, SQLException {
        if (action.equals(HttpParameter.GET_DATABASE_INFO)) {
            ServerSqlDispatchUtil.checkMetadataAuthorized(request, connection, sqlFirewallManagers);
            DatabaseMetaData meta = connection.getMetaData();
            DatabaseInfoDto databaseInfoDto = new DatabaseInfoDto(meta);
            String jsonString = GsonWsUtil.getJSonString(databaseInfoDto);
            ServerSqlManager.writeLine(out, jsonString);
            return true;
        }
        return false;
    }

    private boolean isGetLimitsInfo(HttpServletRequest request, OutputStream out, String action, Connection connection, Set<SqlFirewallManager> sqlFirewallManagers, DatabaseConfigurator databaseConfigurator) throws IOException, SQLException {
        if (action.equals("get_limits_info")) {
            String username = request.getParameter("username");
            String database = request.getParameter("database");
            ServerSqlDispatchUtil.checkMetadataAuthorized(request, connection, sqlFirewallManagers);
            long maxRows = databaseConfigurator.getMaxRows(username, database);
            long maxBlobLength = databaseConfigurator.getMaxBlobLength(username, database);
            LimitsInfoDto limitsInfoDto = new LimitsInfoDto(maxRows, maxBlobLength);
            String jsonString = GsonWsUtil.getJSonString(limitsInfoDto);
            ServerSqlManager.writeLine(out, jsonString);
            return true;
        }
        return false;
    }

    private boolean checkStatelessInAutoCommit(HttpServletRequest request, HttpServletResponse response, OutputStream out, Connection connection) throws IOException, SQLException {
        if (!ConfPropertiesUtil.isStatelessMode()) {
            return true;
        }
        if (ServerSqlDispatchUtil.isActionsSetAutoCommitFalse(request)) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 400, 1, "AceQL Server is in Stateless Mode: can not change auto-commit mode to false.");
            ServerSqlManager.writeLine(out, errorReturn.build());
            return false;
        }
        if (!connection.getAutoCommit()) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 400, 1, "AceQL Server is in Stateless Mode: can not process SQL request because Connection must be in auto-commit.");
            ServerSqlManager.writeLine(out, errorReturn.build());
            return false;
        }
        return true;
    }

    private void dumpHeaders(HttpServletRequest request) {
    }

    private boolean isGetVersion(OutputStream out, String action) throws IOException {
        if (action.equals(HttpParameter.GET_VERSION)) {
            String version = VersionWrapper.getServerVersion();
            ServerSqlManager.writeLine(out, JsonOkReturn.build("result", version));
            return true;
        }
        return false;
    }

    private void dispatch(HttpServletRequest request, HttpServletResponse response, OutputStream out, String action, Connection connection, DatabaseConfigurator databaseConfigurator, Set<SqlFirewallManager> sqlFirewallManagers) throws SQLException, FileNotFoundException, IOException, IllegalArgumentException {
        if (ServerSqlDispatchUtil.isExecute(action) && !ServerSqlDispatchUtil.isStoredProcedure(request)) {
            ServerStatementRawExecute serverStatement = new ServerStatementRawExecute(request, response, sqlFirewallManagers, connection);
            serverStatement.execute(out);
        } else if (ServerSqlDispatchUtil.isExecuteQueryOrExecuteUpdate(action) && !ServerSqlDispatchUtil.isStoredProcedure(request)) {
            ServerStatement serverStatement = new ServerStatement(request, response, sqlFirewallManagers, connection);
            serverStatement.executeQueryOrUpdate(out);
        } else if (ServerSqlDispatchUtil.isStatementExecuteBatch(action)) {
            ServerStatementBatch serverStatement = new ServerStatementBatch(request, response, sqlFirewallManagers, connection, databaseConfigurator);
            serverStatement.executeBatch(out);
        } else if (ServerSqlDispatchUtil.isPreparedStatementExecuteBatch(action)) {
            ServerPreparedStatementBatch serverPreparedStatementBatch = new ServerPreparedStatementBatch(request, response, sqlFirewallManagers, connection, databaseConfigurator);
            serverPreparedStatementBatch.executeBatch(out);
        } else if (ServerSqlDispatchUtil.isStoredProcedure(request)) {
            AdvancedServerCallableStatement advancedServerCallableStatement = new AdvancedServerCallableStatement(request, response, sqlFirewallManagers, connection);
            advancedServerCallableStatement.executeOrExecuteQuery(out);
        } else if (ServerSqlDispatchUtil.isConnectionModifier(action)) {
            TransactionUtil.setConnectionModifierAction(request, response, out, action, connection);
        } else if (ServerSqlDispatchUtil.isSavepointModifier(action)) {
            SavepointUtil.setSavepointExecute(request, response, out, action, connection);
        } else if (ServerSqlDispatchUtil.isConnectionReader(action)) {
            TransactionUtil.getConnectionionInfosExecute(request, response, out, action, connection);
        } else {
            throw new IllegalArgumentException("Invalid Sql Action: " + action);
        }
    }

    private boolean doTreatJdbcDatabaseMetaData(HttpServletRequest request, HttpServletResponse response, OutputStream out, String action, Connection connection, Set<SqlFirewallManager> sqlFirewallManagers) throws SQLException, IOException {
        if (ActionUtil.isJdbcDatabaseMetaDataQuery(action)) {
            DefaultJdbcDatabaseMetadataActionManagerWrap.executeWrap(request, response, out, sqlFirewallManagers, connection);
            return true;
        }
        return false;
    }

    private boolean doTreatMetadataQuery(HttpServletRequest request, HttpServletResponse response, OutputStream out, String action, Connection connection, Set<SqlFirewallManager> sqlFirewallManagers) throws SQLException, IOException {
        if (ActionUtil.isMetadataQueryAction(action) || ActionUtil.isHealthCheckInfo(action)) {
            MetadataQueryActionManager metadataQueryActionManager = new MetadataQueryActionManager(request, response, out, sqlFirewallManagers, connection);
            metadataQueryActionManager.execute();
            return true;
        }
        return false;
    }

    private void treatCloseAction(HttpServletResponse response, OutputStream out, String username, String sessionId, String connectionId, DatabaseConfigurator databaseConfigurator, Connection connection) throws IOException {
        try {
            if (ConfPropertiesUtil.isStatelessMode()) {
                ServerSqlManager.writeLine(out, JsonOkReturn.build());
                return;
            }
            databaseConfigurator.close(connection);
            String connectionIdNew = connectionId;
            if (connectionIdNew == null) {
                connectionIdNew = ConnectionIdUtil.getConnectionId(connection);
            }
            ConnectionStore connectionStore = new ConnectionStore(username, sessionId, connectionIdNew);
            connectionStore.remove();
            ServerSqlManager.writeLine(out, JsonOkReturn.build());
        }
        catch (SQLException e) {
            RollbackUtil.rollback(connection);
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 400, 1, e.getMessage());
            ServerSqlManager.writeLine(out, errorReturn.build());
        }
        catch (Exception e) {
            RollbackUtil.rollback(connection);
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 500, 4, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            ServerSqlManager.writeLine(out, errorReturn.build());
        }
    }

    private boolean doBlobUpload(HttpServletRequest request, HttpServletResponse response, OutputStream out) throws IOException, FileUploadException, SQLException {
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            BlobUploader blobUploader = new BlobUploader(request, response, out);
            blobUploader.blobUpload();
            return true;
        }
        return false;
    }

    public static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

