/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.kawanfw.sql.api.server.SqlEvent;
import org.kawanfw.sql.api.server.SqlEventWrapper;
import org.kawanfw.sql.api.server.firewall.SqlFirewallManager;
import org.kawanfw.sql.api.util.firewall.SqlFirewallTriggerWrapper;
import org.kawanfw.sql.servlet.BannerOnTester;
import org.kawanfw.sql.servlet.sql.ServerStatementUtil;
import org.kawanfw.sql.servlet.sql.json_return.JsonSecurityMessage;
import org.kawanfw.sql.util.IpUtil;

public class ServerSqlDispatchUtil {
    public static boolean isStoredProcedure(HttpServletRequest request) {
        String storedProcedure = request.getParameter("stored_procedure");
        String sql = request.getParameter("sql");
        boolean explicitStoredProcedure = Boolean.parseBoolean(storedProcedure);
        if (explicitStoredProcedure) {
            return true;
        }
        boolean implicitStoredProcedure = false;
        if (sql != null && (sql = sql.trim().toLowerCase()).startsWith("{") && sql.endsWith("}") && sql.contains("call ")) {
            implicitStoredProcedure = true;
        }
        return implicitStoredProcedure;
    }

    public static boolean isActionsSetAutoCommitFalse(HttpServletRequest request) {
        String action = request.getParameter("action");
        boolean autoCommit = Boolean.parseBoolean(request.getParameter("action_value"));
        return action.equals("set_auto_commit") && !autoCommit;
    }

    public static boolean isSavepointModifier(String action) {
        return action.equals("set_savepoint") || action.equals("set_named_savepoint") || action.equals("rollback_savepoint") || action.equals("release_savepoint");
    }

    public static boolean isConnectionModifier(String action) {
        return action.equals("set_auto_commit") || action.equals("commit") || action.equals("rollback") || action.equals("set_read_only") || action.equals("set_holdability") || action.equals("set_transaction_isolation_level") || action.equals("close");
    }

    public static boolean isConnectionReader(String action) {
        return action.equals("get_auto_commit") || action.equals("get_catalog") || action.equals("get_sechema") || action.equals("get_holdability") || action.equals("is_read_only") || action.equals("get_transaction_isolation_level");
    }

    public static boolean isActionForBlob(String action) {
        return action.equals("blob_upload") || action.equals("blob_download");
    }

    public static boolean isExecuteQueryOrExecuteUpdate(String action) {
        return action.equals("execute_update") || action.equals("execute_query");
    }

    public static boolean isExecute(String action) {
        return action.equals("execute");
    }

    public static boolean isStatementExecuteBatch(String action) {
        return action.equals("statement_execute_batch");
    }

    public static boolean isPreparedStatementExecuteBatch(String action) {
        return action.equals("prepared_statement_execute_batch");
    }

    public static void checkMetadataAuthorized(HttpServletRequest request, Connection connection, Set<SqlFirewallManager> sqlFirewallManagers) throws IOException, SQLException {
        String username = request.getParameter("username");
        String database = request.getParameter("database");
        String ipAddress = IpUtil.getRemoteAddr(request);
        boolean allow = true;
        String sql = "<void>";
        for (SqlFirewallManager sqlFirewallManager : sqlFirewallManagers) {
            allow = sqlFirewallManager.allowMetadataQuery(username, database, connection);
            if (allow) continue;
            ArrayList<Object> parameterValues = new ArrayList<Object>();
            SqlEvent sqlEvent = SqlEventWrapper.sqlEventBuild(username, database, ipAddress, sql, ServerStatementUtil.isPreparedStatement(request), parameterValues, true);
            SqlFirewallTriggerWrapper.runIfStatementRefused(sqlEvent, sqlFirewallManager, connection);
            break;
        }
        if (!allow) {
            HashMap<Integer, String> parameters = new HashMap<Integer, String>();
            ArrayList<Object> values = new ArrayList<Object>();
            String message = JsonSecurityMessage.prepStatementNotAllowedBuild(sql, "Metadata Query API calls are not allowed!", parameters, values, true);
            throw new SecurityException(message);
        }
    }

    /*
     * Loose catch block
     */
    public static boolean isUsernameBanned(String username, String database, Connection connection) throws SQLException {
        if (!BannerOnTester.isBanUserSqlFirewallTriggerActivated(database)) {
            return false;
        }
        String sql = "SELECT username FROM aceql_banned_user WHERE username = ?";
        Throwable throwable = null;
        Object var5_6 = null;
        try (PreparedStatement prepStatement = connection.prepareStatement(sql);){
            boolean bl;
            ResultSet rs;
            Throwable throwable2;
            block20: {
                prepStatement.setString(1, username);
                throwable2 = null;
                Object var8_11 = null;
                rs = prepStatement.executeQuery();
                bl = rs.next();
                if (rs == null) break block20;
                rs.close();
            }
            return bl;
            {
                catch (Throwable throwable3) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }
}

