/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.SystemUtils;
import org.apache.tomcat.util.http.fileupload.FileUploadException;
import org.kawanfw.sql.api.server.auth.headers.RequestHeadersAuthenticator;
import org.kawanfw.sql.api.server.session.SessionConfigurator;
import org.kawanfw.sql.servlet.HttpServletRequestHolder;
import org.kawanfw.sql.servlet.PrivateTmpLogger;
import org.kawanfw.sql.servlet.ServerAsyncListener;
import org.kawanfw.sql.servlet.ServerSqlDispatch;
import org.kawanfw.sql.servlet.ServletPathAnalyzer;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesManagerNew;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.injection.properties.ConfPropertiesStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileStore;
import org.kawanfw.sql.servlet.sql.json_return.ExceptionReturner;
import org.kawanfw.sql.servlet.sql.json_return.JsonErrorReturn;
import org.kawanfw.sql.servlet.sql.json_return.JsonOkReturn;
import org.kawanfw.sql.tomcat.TomcatSqlModeStore;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.IpUtil;
import org.kawanfw.sql.util.SqlTag;
import org.kawanfw.sql.util.TimestampUtil;
import org.kawanfw.sql.version.VersionWrapper;

public class ServerSqlManager
extends HttpServlet {
    private static boolean DEBUG = FrameworkDebug.isSet(ServerSqlManager.class);
    public static String CR_LF = System.getProperty("line.separator");
    public static final String STATELESS_MODE = "statelessMode";
    public static final String DATABASE_CONFIGURATOR_CLASS_NAME = "databaseConfiguratorClassName";
    public static final String USER_AUTHENTICATOR_CLASS_NAME = "userAuthenticatorClassName";
    public static final String REQUEST_HEADERS_AUTHENTICATOR_CLASS_NAME = "requestHeadersAuthenticatorClassName";
    public static final String SQL_FIREWALL_MANAGER_CLASS_NAMES = "sqlFirewallManagerClassNames";
    public static final String SQL_FIREWALL_TRIGGER_CLASS_NAMES = "sqlFirewallTriggerClassNames";
    public static final String BLOB_DOWNLOAD_CONFIGURATOR_CLASS_NAME = "blobDownloadConfiguratorClassName";
    public static final String BLOB_UPLOAD_CONFIGURATOR_CLASS_NAME = "blobUploadConfiguratorClassName";
    public static final String SESSION_CONFIGURATOR_CLASS_NAME = "sessionConfiguratorClassName";
    public static final String JWT_SESSION_CONFIGURATOR_SECRET = "jwtSessionConfiguratorSecret";
    public static final String UPDATE_LISTENER_MANAGER_CLASS_NAMES = "updateListenerClassNames";
    private static boolean INIT_DONE = false;
    private String propertiesFileStr;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        INIT_DONE = false;
        this.propertiesFileStr = config.getInitParameter("properties");
        if (!TomcatSqlModeStore.isTomcatEmbedded()) {
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_INIT) + " " + TimestampUtil.getHumanTimestampNoMillisNow() + " Call the AceQL Servlet from a browser to display full start in Tomcat logs...");
            System.out.println();
        }
        if (this.propertiesFileStr == null) {
            this.propertiesFileStr = PropertiesFileStore.get().toString();
        }
        ServerSqlManager.debug("propertiesFileStr: " + this.propertiesFileStr);
    }

    public void destroy() {
        ThreadPoolExecutor threadPoolExecutor;
        super.destroy();
        INIT_DONE = false;
        if (InjectedClassesStore.get() != null && InjectedClassesStore.get().getThreadPoolExecutor() != null && (threadPoolExecutor = InjectedClassesStore.get().getThreadPoolExecutor()) != null) {
            try {
                threadPoolExecutor.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServerSqlManager.createClassesSynchronized(this.propertiesFileStr);
        final AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(0L);
        asyncContext.addListener((AsyncListener)new ServerAsyncListener());
        ThreadPoolExecutor threadPoolExecutor = InjectedClassesStore.get().getThreadPoolExecutor();
        Objects.requireNonNull(threadPoolExecutor, "threadPoolExecutor cannot be null!");
        threadPoolExecutor.execute(new Runnable(){

            @Override
            public void run() {
                HttpServletRequest request = (HttpServletRequest)asyncContext.getRequest();
                HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                try {
                    ServerSqlManager.this.handleRequestWrapper(request, response);
                }
                finally {
                    asyncContext.complete();
                }
            }
        });
    }

    public static synchronized void createClassesSynchronized(String propertiesFileStr) throws ServletException, IOException {
        if (!INIT_DONE) {
            INIT_DONE = true;
            InjectedClassesManagerNew injectedClassesManager = new InjectedClassesManagerNew();
            injectedClassesManager.createClasses(propertiesFileStr);
        }
    }

    private void handleRequestWrapper(HttpServletRequest request, HttpServletResponse response) {
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            this.handleRequest(request, response, (OutputStream)out);
        }
        catch (Throwable e) {
            try {
                PrivateTmpLogger privateTmpLogger = new PrivateTmpLogger(e);
                privateTmpLogger.log();
                ExceptionReturner.logAndReturnException(request, response, (OutputStream)out, e);
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.out);
            }
        }
    }

    private void handleRequest(HttpServletRequest request, HttpServletResponse response, OutputStream out) throws UnsupportedEncodingException, IOException, SQLException, FileUploadException {
        request.setCharacterEncoding("UTF-8");
        ServerSqlManager.debug("after RequestInfoStore.init(request);");
        ServerSqlManager.debug(IpUtil.getRemoteAddr(request));
        HttpServletRequestHolder requestHolder = new HttpServletRequestHolder(request);
        ServerSqlDispatch dispatch = new ServerSqlDispatch();
        ServerSqlManager.debug("before dispatch.executeRequest()");
        String database = null;
        String username = null;
        String sessionId = null;
        String connectionId = null;
        String action = null;
        String actionValue = null;
        ServerSqlManager.debug("servlet Path : " + request.getServletPath());
        ServerSqlManager.debug("getRequestURI: " + request.getRequestURI());
        String servletPath = request.getServletPath();
        String requestUri = request.getRequestURI();
        String servletCallName = ConfPropertiesStore.get().getServletCallName();
        if (!this.checkRequestStartsWithAceqlServlet(response, out, servletPath, requestUri, servletCallName)) {
            return;
        }
        if (this.getVersion(out, requestUri, servletCallName)) {
            return;
        }
        try {
            ServletPathAnalyzer servletPathAnalyzer = new ServletPathAnalyzer(requestUri, servletCallName);
            action = servletPathAnalyzer.getAction();
            actionValue = servletPathAnalyzer.getActionValue();
            database = servletPathAnalyzer.getDatabase();
            username = servletPathAnalyzer.getUsername();
            sessionId = servletPathAnalyzer.getSession();
            connectionId = servletPathAnalyzer.getConnection();
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 400, 2, errorMessage);
            ServerSqlManager.writeLine(out, errorReturn.build());
            return;
        }
        if (!this.validateHeaders(request, response, out)) {
            return;
        }
        if (username == null && database == null) {
            if (!this.checkSessionIsVerified(response, out, sessionId)) {
                return;
            }
            SessionConfigurator sessionConfigurator = InjectedClassesStore.get().getSessionConfigurator();
            username = sessionConfigurator.getUsername(sessionId);
            database = sessionConfigurator.getDatabase(sessionId);
            if (!this.checkUsernameAndDatabase(response, out, database, username)) {
                return;
            }
        }
        this.debugValues(database, username, sessionId, connectionId, action, actionValue);
        requestHolder.setParameter("action", action);
        requestHolder.setParameter("action_value", actionValue);
        requestHolder.setParameter("session_id", sessionId);
        requestHolder.setParameter("connection_id", connectionId);
        requestHolder.setParameter("username", username);
        requestHolder.setParameter("database", database);
        ServerSqlManager.testThrowException();
        dispatch.executeRequestInTryCatch((HttpServletRequest)requestHolder, response, out);
    }

    private boolean validateHeaders(HttpServletRequest request, HttpServletResponse response, OutputStream out) throws IOException {
        RequestHeadersAuthenticator requestHeadersAuthenticator = InjectedClassesStore.get().getRequestHeadersAuthenticator();
        if (requestHeadersAuthenticator == null) {
            return true;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = request.getHeader(key);
            headers.put(key, value);
        }
        boolean checked = requestHeadersAuthenticator.validate(headers);
        if (!checked) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 401, 2, "Invalid session_id.");
            ServerSqlManager.writeLine(out, errorReturn.build());
            return false;
        }
        return checked;
    }

    private void debugValues(String database, String username, String sessionId, String connectionId, String action, String actionValue) {
        ServerSqlManager.debug("");
        ServerSqlManager.debug("action      : " + action);
        ServerSqlManager.debug("actionValue : " + actionValue);
        ServerSqlManager.debug("username    : " + username);
        ServerSqlManager.debug("sessionId   : " + sessionId);
        ServerSqlManager.debug("connectionId: " + connectionId);
        ServerSqlManager.debug("database    : " + database);
    }

    private boolean checkUsernameAndDatabase(HttpServletResponse response, OutputStream out, String database, String username) throws IOException {
        if (username == null || database == null) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 401, 2, "Invalid session_id.");
            ServerSqlManager.writeLine(out, errorReturn.build());
            return false;
        }
        return true;
    }

    private boolean checkSessionIsVerified(HttpServletResponse response, OutputStream out, String sessionId) throws IOException {
        SessionConfigurator sessionConfigurator = InjectedClassesStore.get().getSessionConfigurator();
        boolean isVerified = sessionConfigurator.verifySessionId(sessionId);
        if (!isVerified) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 401, 2, "Invalid session_id.");
            ServerSqlManager.writeLine(out, errorReturn.build());
        }
        return isVerified;
    }

    private boolean getVersion(OutputStream out, String requestUri, String servletCallName) throws IOException {
        if (requestUri.endsWith("/" + servletCallName) || requestUri.endsWith("/" + servletCallName + "/")) {
            String version = VersionWrapper.getServerVersion();
            ServerSqlManager.writeLine(out, JsonOkReturn.build("version", version));
            return true;
        }
        return false;
    }

    private boolean checkRequestStartsWithAceqlServlet(HttpServletResponse response, OutputStream out, String servletPath, String requestUri, String servletCallName) throws IOException {
        if (!requestUri.startsWith("/" + servletCallName) && !servletPath.startsWith("/" + servletCallName)) {
            if (requestUri.equals("/")) {
                JsonErrorReturn errorReturn = new JsonErrorReturn(response, 400, 2, "AceQL main servlet not found in path: " + servletCallName);
                ServerSqlManager.writeLine(out, errorReturn.build());
                return false;
            }
            String servlet = requestUri.substring(1);
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 400, 2, "This servlet is unknown and has not been declared in properties file: " + servlet);
            ServerSqlManager.writeLine(out, errorReturn.build());
            return false;
        }
        return true;
    }

    public static void testThrowException() {
        File file = new File(String.valueOf(SystemUtils.USER_HOME) + File.separator + ".kawansoft" + File.separator + "throw_exception.txt");
        if (file.exists()) {
            throw new IllegalArgumentException("Exception thrown because user.home/.kawansoft/throw_exception.txt exists!");
        }
    }

    public static void write(OutputStream out, String s) throws IOException {
        out.write((String.valueOf(s) + CR_LF).getBytes("UTF-8"));
    }

    public static void writeLine(OutputStream out) throws IOException {
        out.write(CR_LF.getBytes("UTF-8"));
    }

    public static void writeLine(OutputStream out, String s) throws IOException {
        out.write((String.valueOf(s) + CR_LF).getBytes("UTF-8"));
    }

    public static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + ServerSqlManager.class.getSimpleName() + " " + s);
        }
    }
}

