/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Date;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.kawanfw.sql.api.server.DatabaseConfigurationException;
import org.kawanfw.sql.api.server.DefaultDatabaseConfigurator;
import org.kawanfw.sql.servlet.injection.properties.ConfPropertiesStore;
import org.kawanfw.sql.tomcat.TomcatSqlModeStore;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.version.VersionWrapper;

public class ServerSqlManagerDoGetTester {
    private static boolean DEBUG = FrameworkDebug.isSet(ServerSqlManagerDoGetTester.class);
    public static final String KAWANSOFT_COLOR = "E7403E";
    public static String CR_LF = System.getProperty("line.separator");
    public static final String DATABASE_CONFIGURATOR_CLASS_NAME = "databaseConfiguratorClassName";
    private String initErrrorMesage = "";

    public void doGetTest(HttpServletResponse response, String servletCallName, Exception exception) throws IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        ServerSqlManagerDoGetTester.debug("doGetTest begin");
        try {
            String status = "</font><font face=\"Arial\" color=\"green\">OK & Running.";
            if (exception != null) {
                ServerSqlManagerDoGetTester.debug("exception != null");
                if (TomcatSqlModeStore.isTomcatEmbedded()) {
                    status = exception.toString();
                    out.println(status);
                    ServerSqlManagerDoGetTester.debug("after out.println(status)");
                    return;
                }
                String exceptionDisplay = null;
                exceptionDisplay = exception instanceof DatabaseConfigurationException ? exception.getMessage() : ExceptionUtils.getStackTrace((Throwable)exception);
                BufferedReader bufferedReader = new BufferedReader(new StringReader(exceptionDisplay));
                StringBuffer sb = new StringBuffer();
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    sb.append(line);
                    sb.append("<br>");
                }
                status = "</font><font face=\"Arial\" color=\"red\">" + this.initErrrorMesage + "<br>" + sb.toString();
            }
            this.printResult(servletCallName, out, status);
        }
        catch (Exception e) {
            e.printStackTrace(out);
        }
    }

    private void printResult(String servletCallName, PrintWriter out, String status) {
        Set<String> databases = ConfPropertiesStore.get().getDatabaseNames();
        out.println("<!--OK-->");
        out.println("<br>");
        out.println("<font face=\"Arial\">");
        out.println("<b>");
        out.println("<font color=\"#E7403E\">" + VersionWrapper.getServerVersion() + "</font>");
        out.println("<br>");
        out.println("<br>");
        out.println(String.valueOf(servletCallName) + " Servlet Configuration");
        out.println("</b>");
        out.println("<br><br>");
        out.println("<table cellpadding=\"3\" border=\"1\">");
        out.println("<tr>");
        out.println("<td align=\"center\"> <b>Database Name</b> </td>");
        out.println("<td align=\"center\"> <b>Configurator Parameter</b> </td>");
        out.println("<td align=\"center\"> <b>Configurator Value</b> </td>");
        out.println("</tr>");
        this.printDatabaseConfigurators(out, databases);
        out.println("</table>");
        out.println("<br><br>");
        out.println("<table cellpadding=\"3\" border=\"1\">");
        out.println("<tr>");
        out.println("<td align=\"center\"> <b>SQL Configuration Status</b> </td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td> " + status + "</td>");
        out.println("</tr>");
        out.println("</table>");
        out.println("</font>");
    }

    private void printDatabaseConfigurators(PrintWriter out, Set<String> databases) {
        for (String database : databases) {
            String databaseConfiguratorClassName = ConfPropertiesStore.get().getDatabaseConfiguratorClassName(database);
            if (databaseConfiguratorClassName == null || databaseConfiguratorClassName.isEmpty()) {
                databaseConfiguratorClassName = DefaultDatabaseConfigurator.class.getName();
            }
            out.println("<tr>");
            out.println("<td> " + database + "</td>");
            out.println("<td> databaseConfiguratorClassName</td>");
            out.println("<td> " + databaseConfiguratorClassName + "</td>");
            out.println("</tr>");
        }
    }

    public static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

