/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet;

import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kawanfw.sql.servlet.ServletMetadataQuery;
import org.kawanfw.sql.util.FrameworkDebug;

public class ServletPathAnalyzer {
    private static boolean DEBUG = FrameworkDebug.isSet(ServletPathAnalyzer.class);
    private String connectionModifierOrReader = null;
    private String sqlStatement = null;
    private String blobAction = null;
    private String actionValue = null;
    private String session = null;
    private String connection;
    private String database;
    private String username;
    private String requestUri;
    private String servletCallName;
    private String action;

    public ServletPathAnalyzer(String requestUri, String servletCallName) {
        this.requestUri = requestUri;
        this.servletCallName = servletCallName;
        this.treat();
    }

    private void treat() {
        if (this.isLoginAction(this.requestUri, this.servletCallName)) {
            this.action = "login";
        } else if (this.isVersionAction(this.requestUri)) {
            this.action = "get_version";
            this.buildElements(this.servletCallName, this.requestUri);
        } else if (this.isGetDatabaseInfoAction(this.requestUri)) {
            this.action = "get_database_info";
            this.buildElements(this.servletCallName, this.requestUri);
        } else if (this.isExecuteServerQuery(this.requestUri)) {
            this.action = "execute_server_query";
            this.buildElements(this.servletCallName, this.requestUri);
        } else if (this.isConnectionModifierOrReader(this.requestUri)) {
            this.action = this.getConnectionModifierOrReader();
            this.buildElements(this.servletCallName, this.requestUri);
        } else if (this.isBlobAction(this.requestUri)) {
            this.action = this.getBlobAction();
            this.buildElements(this.servletCallName, this.requestUri);
        } else if (this.isExecuteFamily(this.requestUri)) {
            this.action = this.getSqlStatement();
            this.buildElements(this.servletCallName, this.requestUri);
        } else if (this.isJdbcDatabaseMetaData(this.requestUri)) {
            this.action = "jdbc_database_meta_data";
            this.buildElements(this.servletCallName, this.requestUri);
        } else if (this.isMetadataQuery(this.requestUri)) {
            ServletMetadataQuery servletMetadataQuery = new ServletMetadataQuery(this.requestUri);
            this.action = servletMetadataQuery.getAction();
            this.buildElements(this.servletCallName, this.requestUri);
        } else if (this.isHealthCheckInfo(this.requestUri)) {
            this.action = "health_check_info";
            this.buildElements(this.servletCallName, this.requestUri);
        } else if (this.isLimitsInfo(this.requestUri)) {
            this.action = "get_limits_info";
            this.buildElements(this.servletCallName, this.requestUri);
        } else {
            throw new IllegalArgumentException("Unknown action: " + StringUtils.substringAfterLast((String)this.requestUri, (String)"/"));
        }
    }

    private boolean isHealthCheckInfo(String urlContent) {
        Objects.requireNonNull(urlContent, "urlContent cannot be null!");
        return urlContent.endsWith("/health_check_info");
    }

    private boolean isLimitsInfo(String urlContent) {
        Objects.requireNonNull(urlContent, "urlContent cannot be null!");
        return urlContent.endsWith("/get_limits_info");
    }

    private boolean isExecuteServerQuery(String urlContent) {
        Objects.requireNonNull(urlContent, "urlContent cannot be null!");
        return urlContent.endsWith("/execute_server_query");
    }

    private boolean isGetDatabaseInfoAction(String urlContent) {
        Objects.requireNonNull(urlContent, "urlContent cannot be null!");
        return urlContent.endsWith("/get_database_info");
    }

    public boolean isConnectionModifierOrReader(String requestUri) {
        Objects.requireNonNull(requestUri, "requestUri cannot be null!");
        if (requestUri.endsWith("/get_connection")) {
            this.connectionModifierOrReader = "get_connection";
            return true;
        }
        if (requestUri.endsWith("/get_catalog")) {
            this.connectionModifierOrReader = "get_catalog";
            return true;
        }
        if (requestUri.endsWith("/get_schema")) {
            this.connectionModifierOrReader = "get_catalog";
            return true;
        }
        if (this.checkCloseCommands(requestUri)) {
            return true;
        }
        if (this.checkCommitCommands(requestUri)) {
            return true;
        }
        if (this.checkSavepointCommands(requestUri)) {
            return true;
        }
        if (this.checkHoldabilityAndIsolationCommands(requestUri)) {
            return true;
        }
        return this.checkReadOnlyCommands(requestUri);
    }

    private boolean checkReadOnlyCommands(String requestUri) {
        if (requestUri.endsWith("/set_read_only/true") || requestUri.endsWith("/set_read_only/false")) {
            this.connectionModifierOrReader = "set_read_only";
            this.actionValue = StringUtils.substringAfterLast((String)requestUri, (String)"/");
            return true;
        }
        if (requestUri.endsWith("/is_read_only")) {
            this.connectionModifierOrReader = "is_read_only";
            return true;
        }
        return false;
    }

    private boolean checkHoldabilityAndIsolationCommands(String requestUri) {
        if (requestUri.contains("/set_holdability/")) {
            this.connectionModifierOrReader = "set_holdability";
            this.actionValue = StringUtils.substringAfterLast((String)requestUri, (String)"/");
            return true;
        }
        if (requestUri.endsWith("/get_holdability")) {
            this.connectionModifierOrReader = "get_holdability";
            return true;
        }
        if (requestUri.endsWith("/get_transaction_isolation_level")) {
            this.connectionModifierOrReader = "get_transaction_isolation_level";
            return true;
        }
        if (requestUri.contains("/set_transaction_isolation_level/")) {
            this.connectionModifierOrReader = "set_transaction_isolation_level";
            this.actionValue = StringUtils.substringAfterLast((String)requestUri, (String)"/");
            return true;
        }
        return false;
    }

    private boolean checkCloseCommands(String requestUri) {
        if (requestUri.endsWith("/close")) {
            this.connectionModifierOrReader = "close";
            return true;
        }
        if (requestUri.endsWith("/logout") || requestUri.endsWith("/disconnect")) {
            this.connectionModifierOrReader = "logout";
            return true;
        }
        return false;
    }

    private boolean checkCommitCommands(String requestUri) {
        if (requestUri.endsWith("/commit")) {
            this.connectionModifierOrReader = "commit";
            return true;
        }
        if (requestUri.endsWith("/rollback")) {
            this.connectionModifierOrReader = "rollback";
            return true;
        }
        if (requestUri.endsWith("/set_auto_commit/true") || requestUri.endsWith("/set_auto_commit/false")) {
            this.connectionModifierOrReader = "set_auto_commit";
            this.actionValue = StringUtils.substringAfterLast((String)requestUri, (String)"/");
            return true;
        }
        if (requestUri.endsWith("/get_auto_commit")) {
            this.connectionModifierOrReader = "get_auto_commit";
            return true;
        }
        return false;
    }

    private boolean checkSavepointCommands(String requestUri) {
        if (requestUri.contains("/set_named_savepoint")) {
            this.connectionModifierOrReader = "set_named_savepoint";
            return true;
        }
        if (requestUri.contains("/set_savepoint")) {
            this.connectionModifierOrReader = "set_savepoint";
            return true;
        }
        if (requestUri.contains("/rollback_savepoint")) {
            this.connectionModifierOrReader = "rollback_savepoint";
            return true;
        }
        if (requestUri.contains("/release_savepoint")) {
            this.connectionModifierOrReader = "release_savepoint";
            return true;
        }
        return false;
    }

    public boolean isLoginAction(String requestUri, String servletCallName) {
        String requestUriNew = requestUri;
        if (this.isLoginAction(requestUriNew)) {
            if (!requestUriNew.contains("/" + servletCallName + "/database/")) {
                throw new IllegalArgumentException("Request does not contain /database/ subpath in path");
            }
            if (!requestUriNew.contains("/username/")) {
                throw new IllegalArgumentException("Request does not contain /username/ subpath in path");
            }
            this.database = StringUtils.substringBetween((String)requestUriNew, (String)"/database/", (String)"/username");
            if (requestUriNew.endsWith("/connect")) {
                requestUriNew = String.valueOf(StringUtils.substringBeforeLast((String)requestUriNew, (String)"/connect")) + "/login";
            } else if (requestUriNew.contains("/connect?")) {
                requestUriNew = String.valueOf(StringUtils.substringBeforeLast((String)requestUriNew, (String)"/connect?")) + "/login?";
            }
            this.username = StringUtils.substringBetween((String)requestUriNew, (String)"/username/", (String)"/login");
            return true;
        }
        return false;
    }

    private boolean isLoginAction(String requestUri) {
        return requestUri.endsWith("/login") || requestUri.endsWith("/connect");
    }

    public boolean isVersionAction(String urlContent) {
        Objects.requireNonNull(urlContent, "urlContent cannot be null!");
        return urlContent.endsWith("/get_version");
    }

    public boolean isBlobAction(String urlContent) {
        Objects.requireNonNull(urlContent, "urlContent cannot be null!");
        if (urlContent.endsWith("/blob_upload")) {
            this.blobAction = "blob_upload";
            return true;
        }
        if (urlContent.endsWith("/blob_download")) {
            this.blobAction = "blob_download";
            return true;
        }
        if (urlContent.endsWith("/get_blob_length")) {
            this.blobAction = "get_blob_length";
            return true;
        }
        return false;
    }

    public String getBlobAction() {
        Objects.requireNonNull(this.blobAction, "blobAction cannot be null. Call isBlobAction() before");
        return this.blobAction;
    }

    public String getConnectionModifierOrReader() {
        Objects.requireNonNull(this.connectionModifierOrReader, "connectionModifierOrReader cannot be null. Call isConnectionModifier() before");
        return this.connectionModifierOrReader;
    }

    public boolean isExecuteFamily(String urlContent) {
        Objects.requireNonNull(urlContent, "urlContent cannot be null!");
        if (urlContent.endsWith("/execute_update")) {
            this.sqlStatement = "execute_update";
            return true;
        }
        if (urlContent.endsWith("/execute_query")) {
            this.sqlStatement = "execute_query";
            return true;
        }
        if (urlContent.endsWith("/prepared_statement_execute_batch")) {
            this.sqlStatement = "prepared_statement_execute_batch";
            return true;
        }
        if (urlContent.endsWith("/statement_execute_batch")) {
            this.sqlStatement = "statement_execute_batch";
            return true;
        }
        if (urlContent.endsWith("/execute")) {
            this.sqlStatement = "execute";
            return true;
        }
        return false;
    }

    private boolean isJdbcDatabaseMetaData(String urlContent) {
        Objects.requireNonNull(urlContent, "urlContent cannot be null!");
        return urlContent.contains("/jdbc/database_meta_data");
    }

    public boolean isMetadataQuery(String urlContent) {
        Objects.requireNonNull(urlContent, "urlContent cannot be null!");
        if (!urlContent.contains("/metadata_query/")) {
            return false;
        }
        if (urlContent.contains("/metadata_query/db_schema_download")) {
            return true;
        }
        if (urlContent.contains("/metadata_query/get_table")) {
            return true;
        }
        if (urlContent.endsWith("/metadata_query/get_db_metadata")) {
            return true;
        }
        return urlContent.endsWith("/metadata_query/get_table_names");
    }

    public void buildElements(String servletCallName, String urlContent) {
        Objects.requireNonNull(urlContent, "urlContent cannot be null!");
        if (!urlContent.contains("/session/")) {
            throw new IllegalArgumentException("Request does not contain /session/ subpath in path");
        }
        this.session = StringUtils.substringBetween((String)urlContent, (String)"/session/", (String)"/");
        if (this.session == null) {
            throw new IllegalArgumentException("Request does not contain session id");
        }
        this.connection = StringUtils.substringBetween((String)urlContent, (String)"/connection/", (String)"/");
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.username;
    }

    public String getSession() {
        return this.session;
    }

    public String getConnection() {
        return this.connection;
    }

    public String getSqlStatement() {
        return this.sqlStatement;
    }

    public String getActionValue() {
        return this.actionValue;
    }

    public String getAction() {
        return this.action;
    }

    public static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

