/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.connection;

import java.sql.Array;
import java.sql.Connection;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.kawanfw.sql.api.server.connectionstore.ConnectionKey;
import org.kawanfw.sql.util.FrameworkDebug;

public class ConnectionStore {
    private static boolean DEBUG = FrameworkDebug.isSet(ConnectionStore.class);
    private ConnectionKey connectionKey = null;
    private static Map<ConnectionKey, Connection> connectionMap = new ConcurrentHashMap<ConnectionKey, Connection>();
    private static Map<ConnectionKey, Set<Savepoint>> savepointMap = new ConcurrentHashMap<ConnectionKey, Set<Savepoint>>();
    private static Map<ConnectionKey, Set<Array>> arrayMap = new ConcurrentHashMap<ConnectionKey, Set<Array>>();
    private static Map<ConnectionKey, Set<RowId>> rowIdMap = new ConcurrentHashMap<ConnectionKey, Set<RowId>>();

    public ConnectionStore(String username, String sessionId, String connectionId) {
        if (username == null) {
            throw new IllegalArgumentException("username is null!");
        }
        if (sessionId == null) {
            throw new IllegalArgumentException("sessionId is null!");
        }
        this.connectionKey = new ConnectionKey(username, sessionId, connectionId);
    }

    public void put(Connection connection) {
        ConnectionStore.debug("Creating a Connection for user: " + this.connectionKey);
        if (connection == null) {
            throw new IllegalArgumentException("connection is null!");
        }
        connectionMap.put(this.connectionKey, connection);
    }

    public void put(Savepoint savepoint) {
        ConnectionStore.debug("Creating a Savepoint for user: " + this.connectionKey);
        if (savepoint == null) {
            throw new IllegalArgumentException("savepoint is null!");
        }
        Set<Savepoint> savepointSet = savepointMap.get(this.connectionKey);
        if (savepointSet == null) {
            savepointSet = new LinkedHashSet<Savepoint>();
        }
        savepointSet.add(savepoint);
        savepointMap.put(this.connectionKey, savepointSet);
    }

    public Savepoint getSavepoint(int savepointId) {
        Set<Savepoint> savepointSet = savepointMap.get(this.connectionKey);
        for (Savepoint savepoint : savepointSet) {
            try {
                if (savepoint.getSavepointId() != savepointId) continue;
                return savepoint;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public Savepoint getSavepoint(String savepointName) {
        Set<Savepoint> savepointSet = savepointMap.get(this.connectionKey);
        for (Savepoint savepoint : savepointSet) {
            try {
                if (!savepoint.getSavepointName().equals(savepointName)) continue;
                return savepoint;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public void remove(Savepoint savepointInfo) {
        Set<Savepoint> savepointSet = savepointMap.get(this.connectionKey);
        for (Savepoint savepoint : savepointSet) {
            try {
                if (savepoint.getSavepointId() == savepointInfo.getSavepointId()) {
                    savepointSet.remove(savepoint);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (!savepoint.getSavepointName().equals(savepointInfo.getSavepointName())) continue;
                savepointSet.remove(savepoint);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void put(Array array) {
        ConnectionStore.debug("Creating an array for user: " + this.connectionKey);
        if (array == null) {
            throw new IllegalArgumentException("array is null!");
        }
        Set<Array> arraySet = arrayMap.get(this.connectionKey);
        if (arraySet == null) {
            arraySet = new LinkedHashSet<Array>();
        }
        arraySet.add(array);
        arrayMap.put(this.connectionKey, arraySet);
    }

    public Array getArray(int arrayId) {
        Set<Array> arraySet = arrayMap.get(this.connectionKey);
        for (Array array : arraySet) {
            if (array.hashCode() != arrayId) continue;
            return array;
        }
        return null;
    }

    public void put(RowId rowId) {
        ConnectionStore.debug("Creating a rowId for user: " + this.connectionKey);
        if (rowId == null) {
            throw new IllegalArgumentException("rowId is null!");
        }
        Set<RowId> rowIdSet = rowIdMap.get(this.connectionKey);
        if (rowIdSet == null) {
            rowIdSet = new LinkedHashSet<RowId>();
        }
        rowIdSet.add(rowId);
        rowIdMap.put(this.connectionKey, rowIdSet);
    }

    public RowId getRowId(int rowIdHashCode) {
        Set<RowId> rowIdSet = rowIdMap.get(this.connectionKey);
        for (RowId rowId : rowIdSet) {
            if (rowId.hashCode() != rowIdHashCode) continue;
            return rowId;
        }
        return null;
    }

    public Connection get() {
        return connectionMap.get(this.connectionKey);
    }

    public static Map<ConnectionKey, Connection> getConnectionMap() {
        return connectionMap;
    }

    public void remove() {
        ConnectionStore.debug("Removing a Connection for user: " + this.connectionKey);
        connectionMap.remove(this.connectionKey);
        savepointMap.remove(this.connectionKey);
        arrayMap.remove(this.connectionKey);
        rowIdMap.remove(this.connectionKey);
    }

    public static void remove(ConnectionKey connectionKey) {
        connectionMap.remove(connectionKey);
        savepointMap.remove(connectionKey);
        arrayMap.remove(connectionKey);
        rowIdMap.remove(connectionKey);
    }

    public int size() {
        return connectionMap.size();
    }

    public static Set<ConnectionKey> getKeys() {
        return connectionMap.keySet();
    }

    public static Set<Connection> getAllConnections(String username, String sessionId) {
        HashSet<Connection> connections = new HashSet<Connection>();
        for (ConnectionKey connectionKey : connectionMap.keySet()) {
            if (!connectionKey.getUsername().equals(username) || !connectionKey.getSessionId().equals(sessionId)) continue;
            Connection connection = connectionMap.get(connectionKey);
            connections.add(connection);
        }
        return connections;
    }

    public Connection getFirst() throws SQLException {
        Set<Connection> connections = ConnectionStore.getAllConnections(this.connectionKey.getUsername(), this.connectionKey.getSessionId());
        if (connections.isEmpty()) {
            throw new SQLException("No Connection stored for (" + this.connectionKey.getUsername() + ", " + this.connectionKey.getSessionId() + ")");
        }
        ArrayList<Connection> connectionsList = new ArrayList<Connection>();
        connectionsList.addAll(connections);
        return (Connection)connectionsList.get(0);
    }

    public static void removeAll(String username, String sessionId) {
        HashSet<ConnectionKey> connectionsKeys = new HashSet<ConnectionKey>(connectionMap.keySet());
        for (ConnectionKey connectionKey : connectionsKeys) {
            if (!connectionKey.getUsername().equals(username) || !connectionKey.getSessionId().equals(sessionId)) continue;
            connectionMap.remove(connectionKey);
        }
    }

    public static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

