/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.connection;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.kawanfw.sql.servlet.connection.ConnectionStore;
import org.kawanfw.sql.servlet.connection.RollbackUtil;
import org.kawanfw.sql.servlet.sql.json_return.JsonErrorReturn;

public class ConnectionStoreGetter {
    private HttpServletResponse response;
    private String username;
    private String sessionId;
    private String connectionId;
    private JsonErrorReturn jsonErrorReturn;

    public ConnectionStoreGetter(HttpServletRequest request, HttpServletResponse response) {
        this.response = response;
        this.username = request.getParameter("username");
        this.sessionId = request.getParameter("session_id");
        this.connectionId = request.getParameter("connection_id");
    }

    public Connection getConnection() throws IOException {
        Connection connection = null;
        try {
            ConnectionStore connectionStore = new ConnectionStore(this.username, this.sessionId, this.connectionId);
            connection = this.connectionId == null || this.connectionId.isEmpty() ? connectionStore.getFirst() : connectionStore.get();
            if (connection == null || connection.isClosed()) {
                this.jsonErrorReturn = new JsonErrorReturn(this.response, 404, 2, "Invalid or exipred Connection.");
            }
        }
        catch (SQLException e) {
            RollbackUtil.rollback(connection);
            this.jsonErrorReturn = new JsonErrorReturn(this.response, 400, 2, "Unable to get a Connection.", ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (Exception e) {
            RollbackUtil.rollback(connection);
            this.jsonErrorReturn = new JsonErrorReturn(this.response, 500, 4, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
        }
        return connection;
    }

    public JsonErrorReturn getJsonErrorReturn() {
        return this.jsonErrorReturn;
    }
}

