/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.connection;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.kawanfw.sql.metadata.util.GsonWsUtil;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.connection.ConnectionStore;
import org.kawanfw.sql.servlet.connection.RollbackUtil;
import org.kawanfw.sql.servlet.connection.SavepointDto;
import org.kawanfw.sql.servlet.sql.json_return.JsonErrorReturn;
import org.kawanfw.sql.servlet.sql.json_return.JsonOkReturn;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.HtmlConverter;

public class SavepointUtil {
    private static boolean DEBUG = FrameworkDebug.isSet(SavepointUtil.class);

    public static void setSavepointExecute(HttpServletRequest request, HttpServletResponse response, OutputStream out, String action, Connection connection) throws IOException, SQLException, IllegalArgumentException {
        try {
            SavepointUtil.saveSavePointExecuteThrowException(request, out, action, connection);
        }
        catch (IllegalArgumentException e) {
            RollbackUtil.rollback(connection);
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 500, 2, e.getMessage());
            ServerSqlManager.writeLine(out, errorReturn.build());
        }
        catch (SQLException e) {
            RollbackUtil.rollback(connection);
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 400, 1, e.getMessage());
            ServerSqlManager.writeLine(out, errorReturn.build());
        }
        catch (Exception e) {
            RollbackUtil.rollback(connection);
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 500, 4, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            ServerSqlManager.writeLine(out, errorReturn.build());
        }
    }

    private static void saveSavePointExecuteThrowException(HttpServletRequest request, OutputStream out, String action, Connection connection) throws SQLException, IOException {
        String username = request.getParameter("username");
        String sessionId = request.getParameter("session_id");
        String connectionId = request.getParameter("connection_id");
        ConnectionStore connectionStore = new ConnectionStore(username, sessionId, connectionId);
        SavepointUtil.debug("action: " + action);
        if (action.equals("set_savepoint")) {
            Savepoint savepoint = connection.setSavepoint();
            connectionStore.put(savepoint);
            SavepointDto savepointDto = new SavepointDto(savepoint.getSavepointId(), "");
            String jsonString = GsonWsUtil.getJSonString(savepointDto);
            ServerSqlManager.writeLine(out, jsonString);
            return;
        }
        if (action.equals("set_named_savepoint")) {
            String name = request.getParameter("name");
            name = HtmlConverter.fromHtml(name);
            SavepointUtil.debug("savepoint name: " + name);
            Savepoint savepoint = connection.setSavepoint(name);
            connectionStore.put(savepoint);
            SavepointDto savepointDto = new SavepointDto(-1, savepoint.getSavepointName());
            String jsonString = GsonWsUtil.getJSonString(savepointDto);
            ServerSqlManager.writeLine(out, jsonString);
            return;
        }
        if (action.equals("rollback_savepoint")) {
            Savepoint savepoint;
            String idStr = request.getParameter("id");
            String name = request.getParameter("name");
            if (idStr == null || idStr.isEmpty()) {
                idStr = "-1";
            }
            int id = Integer.parseInt(idStr);
            name = HtmlConverter.fromHtml(name);
            SavepointUtil.debug("Uploaded savepoint id  : " + id);
            SavepointUtil.debug("Uploaded savepoint name: " + name);
            Savepoint savepoint2 = savepoint = id >= 0 ? connectionStore.getSavepoint(id) : connectionStore.getSavepoint(name);
            if (savepoint == null) {
                throw new SQLException("Savepoint does not exists anymore.");
            }
            connection.rollback(savepoint);
            ServerSqlManager.writeLine(out, JsonOkReturn.build());
            return;
        }
        if (action.equals("release_savepoint")) {
            Savepoint savepoint;
            String idStr = request.getParameter("id");
            String name = request.getParameter("name");
            if (idStr == null || idStr.isEmpty()) {
                idStr = "-1";
            }
            int id = Integer.parseInt(idStr);
            name = HtmlConverter.fromHtml(name);
            Savepoint savepoint3 = savepoint = id >= 0 ? connectionStore.getSavepoint(id) : connectionStore.getSavepoint(name);
            if (savepoint == null) {
                throw new SQLException("Savepoint does not exists anymore.");
            }
            connection.releaseSavepoint(savepoint);
            connectionStore.remove(savepoint);
            ServerSqlManager.writeLine(out, JsonOkReturn.build());
            return;
        }
        throw new IllegalArgumentException("Invalid Sql Action for setSavepointExecute(): " + action);
    }

    public static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

