/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.connection;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.connection.RollbackUtil;
import org.kawanfw.sql.servlet.sql.json_return.JsonErrorReturn;
import org.kawanfw.sql.servlet.sql.json_return.JsonOkReturn;
import org.kawanfw.sql.util.FrameworkDebug;

public class TransactionUtil {
    private static boolean DEBUG = FrameworkDebug.isSet(TransactionUtil.class);

    public static void setConnectionModifierAction(HttpServletRequest request, HttpServletResponse response, OutputStream out, String action, Connection connection) throws IOException, SQLException, IllegalArgumentException {
        try {
            if (action.equals("commit")) {
                connection.commit();
            } else if (action.equals("rollback")) {
                connection.rollback();
            } else if (action.equals("set_auto_commit")) {
                boolean autoCommit = Boolean.parseBoolean(request.getParameter("action_value"));
                connection.setAutoCommit(autoCommit);
            } else if (action.equals("set_read_only")) {
                boolean readOnly = Boolean.parseBoolean(request.getParameter("action_value"));
                connection.setReadOnly(readOnly);
            } else if (action.equals("set_holdability")) {
                int holdability = TransactionUtil.getHoldability(request.getParameter("action_value"));
                connection.setHoldability(holdability);
            } else if (action.equals("set_transaction_isolation_level")) {
                int level = TransactionUtil.getTransactionIsolation(request.getParameter("action_value"));
                connection.setTransactionIsolation(level);
            } else {
                throw new IllegalArgumentException("Invalid Sql Action: " + action);
            }
            ServerSqlManager.writeLine(out, JsonOkReturn.build());
        }
        catch (IllegalArgumentException e) {
            RollbackUtil.rollback(connection);
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 500, 2, e.getMessage());
            ServerSqlManager.writeLine(out, errorReturn.build());
        }
        catch (SQLException e) {
            RollbackUtil.rollback(connection);
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 400, 1, e.getMessage());
            ServerSqlManager.writeLine(out, errorReturn.build());
        }
        catch (Exception e) {
            RollbackUtil.rollback(connection);
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 500, 4, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            ServerSqlManager.writeLine(out, errorReturn.build());
        }
    }

    public static void getConnectionionInfosExecute(HttpServletRequest request, HttpServletResponse response, OutputStream out, String action, Connection connection) throws IOException, SQLException, IllegalArgumentException {
        block10: {
            try {
                if (action.equals("get_auto_commit")) {
                    boolean autoCommit = connection.getAutoCommit();
                    ServerSqlManager.writeLine(out, JsonOkReturn.build("result", "" + autoCommit));
                    break block10;
                }
                if (action.equals("is_read_only")) {
                    boolean readOnly = connection.isReadOnly();
                    ServerSqlManager.writeLine(out, JsonOkReturn.build("result", "" + readOnly));
                    break block10;
                }
                if (action.equals("get_catalog")) {
                    String result = connection.getCatalog();
                    result = TransactionUtil.getNonNullResult(result);
                    ServerSqlManager.writeLine(out, JsonOkReturn.build("result", result));
                    break block10;
                }
                if (action.equals("get_sechema")) {
                    String result = connection.getSchema();
                    result = TransactionUtil.getNonNullResult(result);
                    ServerSqlManager.writeLine(out, JsonOkReturn.build("result", result));
                    break block10;
                }
                if (action.equals("get_holdability")) {
                    int holdability = connection.getHoldability();
                    String strHoldability = TransactionUtil.getHoldabilityAsString(holdability);
                    ServerSqlManager.writeLine(out, JsonOkReturn.build("result", strHoldability));
                    break block10;
                }
                if (action.equals("get_transaction_isolation_level")) {
                    int transactionIsolation = connection.getTransactionIsolation();
                    String strTransactionIsolation = TransactionUtil.getTransactionIsolationAsString(transactionIsolation);
                    ServerSqlManager.writeLine(out, JsonOkReturn.build("result", strTransactionIsolation));
                    break block10;
                }
                throw new IllegalArgumentException("Invalid Sql Action: " + action);
            }
            catch (IllegalArgumentException e) {
                RollbackUtil.rollback(connection);
                JsonErrorReturn errorReturn = new JsonErrorReturn(response, 500, 2, e.getMessage());
                ServerSqlManager.writeLine(out, errorReturn.build());
            }
            catch (SQLException e) {
                RollbackUtil.rollback(connection);
                JsonErrorReturn errorReturn = new JsonErrorReturn(response, 400, 1, e.getMessage());
                ServerSqlManager.writeLine(out, errorReturn.build());
            }
            catch (Exception e) {
                RollbackUtil.rollback(connection);
                JsonErrorReturn errorReturn = new JsonErrorReturn(response, 500, 4, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
                ServerSqlManager.writeLine(out, errorReturn.build());
            }
        }
    }

    private static String getNonNullResult(String result) {
        if (result == null) {
            return "null";
        }
        return result;
    }

    private static String getTransactionIsolationAsString(int transactionIsolationLevel) {
        if (transactionIsolationLevel == 0) {
            return "none";
        }
        if (transactionIsolationLevel == 1) {
            return "read_uncommitted";
        }
        if (transactionIsolationLevel == 2) {
            return "read_committed";
        }
        if (transactionIsolationLevel == 4) {
            return "repeatable_read";
        }
        if (transactionIsolationLevel == 8) {
            return "serializable";
        }
        return "UNKNOWN";
    }

    private static int getTransactionIsolation(String actionValue) {
        if (actionValue.equals("read_uncommitted")) {
            return 1;
        }
        if (actionValue.equals("read_committed")) {
            return 2;
        }
        if (actionValue.equals("repeatable_read")) {
            return 4;
        }
        if (actionValue.equals("serializable")) {
            return 8;
        }
        throw new IllegalArgumentException("Unsupported Transaction Isolation Level: " + actionValue);
    }

    private static int getHoldability(String actionValue) {
        if (actionValue.equals("hold_cursors_over_commit")) {
            return 1;
        }
        if (actionValue.equals("close_cursors_at_commit")) {
            return 2;
        }
        throw new IllegalArgumentException("Unsupported Holdability: " + actionValue);
    }

    private static String getHoldabilityAsString(int holdability) {
        if (holdability == 1) {
            return "hold_cursors_over_commit";
        }
        if (holdability == 2) {
            return "close_cursors_at_commit";
        }
        throw new IllegalArgumentException("Unsupported Holdability: " + holdability);
    }

    public static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

