/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.injection.classes;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.kawanfw.sql.api.server.DatabaseConfigurationException;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileUtil;
import org.kawanfw.sql.tomcat.properties.threadpool.ThreadPoolExecutorBuilder;
import org.kawanfw.sql.tomcat.properties.threadpool.ThreadPoolProperties;
import org.kawanfw.sql.util.SqlTag;

public class AdvancedThreadPoolExecutorBuilder
implements ThreadPoolExecutorBuilder {
    @Override
    public ThreadPoolExecutor build() throws DatabaseConfigurationException, IOException, SQLException {
        File propertiesFile = PropertiesFileStore.get();
        Properties properties = PropertiesFileUtil.getProperties(propertiesFile);
        ThreadPoolProperties threadPoolProperties = new ThreadPoolProperties(properties);
        int corePoolSize = threadPoolProperties.getCorePoolSize();
        int maximumPoolSize = threadPoolProperties.getMaximumPoolSize();
        TimeUnit unit = threadPoolProperties.getUnit();
        long keepAliveTime = threadPoolProperties.getKeepAliveTime();
        BlockingQueue<Runnable> workQueue = threadPoolProperties.getWorkQueue();
        boolean prestartAllCoreThreads = threadPoolProperties.isPrestartAllCoreThreads();
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        if (prestartAllCoreThreads) {
            threadPoolExecutor.prestartAllCoreThreads();
        }
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " Loading ThreadPoolExecutor:");
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> [corePoolSize: " + threadPoolExecutor.getCorePoolSize() + ", maximumPoolSize: " + threadPoolExecutor.getMaximumPoolSize() + ", unit: " + (Object)((Object)unit) + ", ");
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  ->  keepAliveTime: " + threadPoolExecutor.getKeepAliveTime(unit) + ", workQueue: " + threadPoolExecutor.getQueue().getClass().getSimpleName() + "(" + threadPoolExecutor.getQueue().remainingCapacity() + "), " + "prestartAllCoreThreads: " + prestartAllCoreThreads + "]");
        return threadPoolExecutor;
    }
}

