/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.injection.classes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.ServletException;
import org.kawanfw.sql.api.server.DatabaseConfigurationException;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.blob.DefaultBlobDownloadConfigurator;
import org.kawanfw.sql.api.server.blob.DefaultBlobUploadConfigurator;
import org.kawanfw.sql.api.server.firewall.SqlFirewallManager;
import org.kawanfw.sql.api.server.firewall.trigger.SqlFirewallTrigger;
import org.kawanfw.sql.api.server.listener.UpdateListener;
import org.kawanfw.sql.api.server.logging.LoggerCreator;
import org.kawanfw.sql.api.server.session.DefaultSessionConfigurator;
import org.kawanfw.sql.api.server.session.JwtSessionConfigurator;
import org.kawanfw.sql.servlet.injection.classes.AdvancedRequestHeadersAuthenticatorLoader;
import org.kawanfw.sql.servlet.injection.classes.AdvancedSqlFirewallTriggersLoader;
import org.kawanfw.sql.servlet.injection.classes.AdvancedThreadPoolExecutorBuilder;
import org.kawanfw.sql.servlet.injection.classes.AdvancedUpdateListenersLoader;
import org.kawanfw.sql.servlet.injection.classes.InjectedClasses;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.injection.classes.creator.BlobDownloadConfiguratorCreator;
import org.kawanfw.sql.servlet.injection.classes.creator.BlobUploadConfiguratorCreator;
import org.kawanfw.sql.servlet.injection.classes.creator.DatabaseConfiguratorCreator;
import org.kawanfw.sql.servlet.injection.classes.creator.SessionConfiguratorCreator;
import org.kawanfw.sql.servlet.injection.classes.creator.SqlFirewallsCreator;
import org.kawanfw.sql.servlet.injection.classes.creator.UserAuthenticatorCreator;
import org.kawanfw.sql.servlet.injection.classes.validator.ThreadPoolCapacityWarner;
import org.kawanfw.sql.servlet.injection.properties.ConfProperties;
import org.kawanfw.sql.servlet.injection.properties.ConfPropertiesManager;
import org.kawanfw.sql.servlet.injection.properties.ConfPropertiesStore;
import org.kawanfw.sql.servlet.injection.properties.ConfPropertiesUtil;
import org.kawanfw.sql.servlet.injection.properties.OperationalMode;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileUtil;
import org.kawanfw.sql.tomcat.TomcatSqlModeStore;
import org.kawanfw.sql.tomcat.TomcatStarterMessages;
import org.kawanfw.sql.tomcat.TomcatStarterUtil;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.SqlTag;
import org.kawanfw.sql.util.Tag;

public class InjectedClassesManagerNew {
    private static boolean DEBUG = FrameworkDebug.isSet(InjectedClassesManagerNew.class);
    public static String CR_LF = System.getProperty("line.separator");
    private String classNameToLoad;

    public void createClasses(String propertiesFileStr) throws ServletException, IOException {
        InjectedClassesManagerNew.debug("propertiesFileStr: " + propertiesFileStr);
        this.classNameToLoad = null;
        try {
            if (!TomcatSqlModeStore.isTomcatEmbedded()) {
                Objects.requireNonNull(propertiesFileStr, "The init param \\\"properties\\\" has not been defined in web.xml!");
                TomcatStarterMessages.printBeginMessage();
                this.createNativeTomcat(propertiesFileStr);
            }
            Set<String> databases = ConfPropertiesStore.get().getDatabaseNames();
            InjectedClasses.InjectedClassesBuilder injectedClassesBuilder = new InjectedClasses.InjectedClassesBuilder();
            this.loadUserAuthenticator(injectedClassesBuilder);
            this.loadRequestHeadersAuthenticator(injectedClassesBuilder);
            AdvancedThreadPoolExecutorBuilder threadPoolExecutorBuilder = new AdvancedThreadPoolExecutorBuilder();
            ThreadPoolExecutor threadPoolExecutor = threadPoolExecutorBuilder.build();
            injectedClassesBuilder.threadPoolExecutor(threadPoolExecutor);
            ThreadPoolCapacityWarner threadPoolCapacityWarner = new ThreadPoolCapacityWarner(propertiesFileStr);
            threadPoolCapacityWarner.warnOnThreadPoolExecutorParams();
            this.loadPerDatabase(databases, injectedClassesBuilder);
            this.loadBlobDownloadConfigurator(injectedClassesBuilder);
            this.loadBlobUploadConfigurator(injectedClassesBuilder);
            this.loadSessionManagerConfigurator(injectedClassesBuilder);
            InjectedClasses injectedClasses = injectedClassesBuilder.build();
            InjectedClassesStore.set(injectedClasses);
            this.displayLoggerCreators();
            if (!TomcatSqlModeStore.isTomcatEmbedded()) {
                TomcatStarterMessages.printFinalOkMessage();
            }
        }
        catch (ClassNotFoundException exception) {
            String initErrrorMesage = String.valueOf(Tag.PRODUCT_USER_CONFIG_FAIL) + " Impossible to load (ClassNotFoundException) Configurator class: " + this.classNameToLoad;
            throw new IOException(initErrrorMesage, exception);
        }
        catch (InstantiationException exception) {
            String initErrrorMesage = String.valueOf(Tag.PRODUCT_USER_CONFIG_FAIL) + " Impossible to load (InstantiationException) Configurator class: " + this.classNameToLoad;
            throw new IOException(initErrrorMesage, exception);
        }
        catch (IllegalAccessException exception) {
            String initErrrorMesage = String.valueOf(Tag.PRODUCT_USER_CONFIG_FAIL) + " Impossible to load (IllegalAccessException) Configurator class: " + this.classNameToLoad;
            throw new IOException(initErrrorMesage, exception);
        }
        catch (DatabaseConfigurationException exception) {
            String initErrrorMesage = exception.getMessage();
            throw new IOException(initErrrorMesage, exception);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            String initErrrorMesage = "ACEQL HTTP " + exception.getMessage();
            throw new IOException(initErrrorMesage);
        }
    }

    public void printWarningMessageNotProtecting(Set<String> databases) {
        for (String database : databases) {
            OperationalMode operationalMode = ConfPropertiesStore.get().getOperationalModeMap(database);
            if (operationalMode.equals((Object)OperationalMode.protecting)) continue;
            System.out.println(SqlTag.SQL_PRODUCT_START);
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " WARNING : Operational Mode is set to \"" + operationalMode.toString() + "\" for database " + database);
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " WARNING : Firewall is not protecting the database: " + database);
        }
    }

    public void displayLoggerCreators() {
        LinkedHashSet loggerCreators = new LinkedHashSet();
        for (LoggerCreator loggerCreator : loggerCreators) {
            System.out.println("ACEQL HTTP  -> " + loggerCreator.getElements());
        }
    }

    public void createNativeTomcat(String propertiesFileStr) throws DatabaseConfigurationException, FileNotFoundException, IOException, SQLException {
        if (propertiesFileStr == null || propertiesFileStr.isEmpty()) {
            throw new DatabaseConfigurationException(String.valueOf(Tag.PRODUCT_USER_CONFIG_FAIL) + " AceQL servlet param-name \"properties\" not set. Impossible to load the AceQL Server properties file.");
        }
        File file = new File(propertiesFileStr);
        if (!file.exists()) {
            throw new DatabaseConfigurationException(String.valueOf(Tag.PRODUCT_USER_CONFIG_FAIL) + " properties file not found: " + propertiesFileStr);
        }
        PropertiesFileStore.set(file);
        Properties properties = PropertiesFileUtil.getProperties(file);
        System.out.println(TomcatStarterUtil.getJavaInfo());
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " " + "Using properties file: ");
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> " + PropertiesFileStore.get());
        ConfPropertiesManager confPropertiesManager = new ConfPropertiesManager(properties);
        ConfProperties confProperties = confPropertiesManager.createConfProperties();
        ConfPropertiesStore.set(confProperties);
        TomcatStarterUtil.createAndStoreDataSources(properties);
    }

    public void loadPerDatabase(Set<String> databases, InjectedClasses.InjectedClassesBuilder injectedClassesBuilder) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException, IOException {
        HashMap<String, Set<SqlFirewallManager>> sqlFirewallManagerMap = new HashMap<String, Set<SqlFirewallManager>>();
        HashMap<String, DatabaseConfigurator> databaseConfigurators = new HashMap<String, DatabaseConfigurator>();
        HashMap<String, Set<SqlFirewallTrigger>> sqlFirewallTriggerMap = new HashMap<String, Set<SqlFirewallTrigger>>();
        HashMap<String, Set<UpdateListener>> updateListenerMap = new HashMap<String, Set<UpdateListener>>();
        for (String database : databases) {
            Set<SqlFirewallManager> sqlFirewalManagers = this.loadSqlFirewallManagers(database);
            sqlFirewallManagerMap.put(database, sqlFirewalManagers);
            DatabaseConfigurator databaseConfigurator = this.loadDatabaseConfigurator(database);
            databaseConfigurators.put(database, databaseConfigurator);
            Set<SqlFirewallTrigger> sqlFirewallTriggers = this.loadSqlFirewallTriggers(database, injectedClassesBuilder);
            sqlFirewallTriggerMap.put(database, sqlFirewallTriggers);
            Set<UpdateListener> updateListeners = this.loadUpdateListeners(database, injectedClassesBuilder);
            updateListenerMap.put(database, updateListeners);
        }
        injectedClassesBuilder.sqlFirewallManagerMap(sqlFirewallManagerMap);
        injectedClassesBuilder.databaseConfigurators(databaseConfigurators);
        injectedClassesBuilder.updateListenerMap(updateListenerMap);
        injectedClassesBuilder.sqlFirewallTriggerMap(sqlFirewallTriggerMap);
    }

    private void treatException() {
    }

    private void loadSessionManagerConfigurator(InjectedClasses.InjectedClassesBuilder injectedClassesBuilder) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, SQLException {
        String sessionConfiguratorClassName = ConfPropertiesStore.get().getSessionConfiguratorClassName();
        if (ConfPropertiesUtil.isStatelessMode() && !sessionConfiguratorClassName.endsWith(JwtSessionConfigurator.class.getSimpleName())) {
            throw new SQLException("[USER CONFIGURATION] Stateless mode is incompatible with DefaultSessionConfigurator implementation. Please use a JwtSessionConfigurator or equivalent in stateless mode.");
        }
        this.classNameToLoad = sessionConfiguratorClassName;
        SessionConfiguratorCreator sessionConfiguratorCreator = new SessionConfiguratorCreator(sessionConfiguratorClassName);
        injectedClassesBuilder.sessionConfigurator(sessionConfiguratorCreator.getSessionConfigurator());
        sessionConfiguratorClassName = sessionConfiguratorCreator.getSessionConfiguratorClassName();
        if (!sessionConfiguratorClassName.equals(DefaultSessionConfigurator.class.getName())) {
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " Loading sessionManagerConfiguratorClassName: ");
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> " + sessionConfiguratorClassName);
        }
    }

    private void loadBlobUploadConfigurator(InjectedClasses.InjectedClassesBuilder injectedClassesBuilder) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, SQLException {
        String blobUploadConfiguratorClassName;
        this.classNameToLoad = blobUploadConfiguratorClassName = ConfPropertiesStore.get().getBlobUploadConfiguratorClassName();
        BlobUploadConfiguratorCreator blobUploadConfiguratorCreator = new BlobUploadConfiguratorCreator(blobUploadConfiguratorClassName);
        injectedClassesBuilder.blobUploadConfigurator(blobUploadConfiguratorCreator.getBlobUploadConfigurator());
        blobUploadConfiguratorClassName = blobUploadConfiguratorCreator.getBlobUploadConfiguratorClassName();
        if (!blobUploadConfiguratorClassName.equals(DefaultBlobUploadConfigurator.class.getName())) {
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " Loading blobUploadConfiguratorClassName: ");
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> " + blobUploadConfiguratorClassName);
        }
    }

    private void loadBlobDownloadConfigurator(InjectedClasses.InjectedClassesBuilder injectedClassesBuilder) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, SQLException {
        String blobDownloadConfiguratorClassName;
        this.classNameToLoad = blobDownloadConfiguratorClassName = ConfPropertiesStore.get().getBlobDownloadConfiguratorClassName();
        BlobDownloadConfiguratorCreator blobDownloadConfiguratorCreator = new BlobDownloadConfiguratorCreator(blobDownloadConfiguratorClassName);
        injectedClassesBuilder.blobDownloadConfigurator(blobDownloadConfiguratorCreator.getBlobDownloadConfigurator());
        blobDownloadConfiguratorClassName = blobDownloadConfiguratorCreator.getBlobDownloadConfiguratorClassName();
        if (!blobDownloadConfiguratorClassName.equals(DefaultBlobDownloadConfigurator.class.getName())) {
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " Loading blobDownloadConfiguratorClassName: ");
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> " + blobDownloadConfiguratorClassName);
        }
    }

    private void loadUserAuthenticator(InjectedClasses.InjectedClassesBuilder injectedClassesBuilder) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String userAuthenticatorClassName;
        this.classNameToLoad = userAuthenticatorClassName = ConfPropertiesStore.get().getUserAuthenticatorClassName();
        UserAuthenticatorCreator userAuthenticatorCreator = new UserAuthenticatorCreator(userAuthenticatorClassName);
        injectedClassesBuilder.userAuthenticator(userAuthenticatorCreator.getUserAuthenticator());
        userAuthenticatorClassName = userAuthenticatorCreator.getUserAuthenticatorClassName();
        if (userAuthenticatorClassName != null) {
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " Loading UserAuthenticator class:");
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> " + userAuthenticatorClassName);
        }
    }

    private void loadRequestHeadersAuthenticator(InjectedClasses.InjectedClassesBuilder injectedClassesBuilder) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        String requestHeadersAuthenticatorClassName;
        this.classNameToLoad = requestHeadersAuthenticatorClassName = ConfPropertiesStore.get().getRequestHeadersAuthenticatorClassName();
        AdvancedRequestHeadersAuthenticatorLoader advancedRequestHeadersAuthenticatorLoader = new AdvancedRequestHeadersAuthenticatorLoader();
        advancedRequestHeadersAuthenticatorLoader.loadRequestHeadersAuthenticator(injectedClassesBuilder, requestHeadersAuthenticatorClassName);
    }

    private Set<UpdateListener> loadUpdateListeners(String database, InjectedClasses.InjectedClassesBuilder injectedClassesBuilder) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException, IOException {
        Set<String> updateListenerClassNames = ConfPropertiesStore.get().getUpdateListenerClassNames(database);
        this.classNameToLoad = updateListenerClassNames.toString();
        AdvancedUpdateListenersLoader updateListenersLoader = new AdvancedUpdateListenersLoader();
        Set<UpdateListener> updateListeners = updateListenersLoader.loadUpdateListeners(database, injectedClassesBuilder, updateListenerClassNames);
        this.classNameToLoad = updateListenersLoader.getClassNameToLoad();
        return updateListeners;
    }

    private Set<SqlFirewallTrigger> loadSqlFirewallTriggers(String database, InjectedClasses.InjectedClassesBuilder injectedClassesBuilder) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException, IOException {
        Set<String> sqlFirewallTriggerClassNames = ConfPropertiesStore.get().getSqlFirewallTriggerClassNames(database);
        this.classNameToLoad = sqlFirewallTriggerClassNames.toString();
        AdvancedSqlFirewallTriggersLoader sqlFirewallTriggersLoader = new AdvancedSqlFirewallTriggersLoader();
        Set<SqlFirewallTrigger> sqlFirewallTriggers = sqlFirewallTriggersLoader.loadSqlFirewallTriggers(database, injectedClassesBuilder, sqlFirewallTriggerClassNames);
        this.classNameToLoad = sqlFirewallTriggersLoader.getClassNameToLoad();
        return sqlFirewallTriggers;
    }

    private Set<SqlFirewallManager> loadSqlFirewallManagers(String database) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException, IOException {
        Set<String> sqlFirewallClassNames = ConfPropertiesStore.get().getSqlFirewallManagerClassNames(database);
        this.classNameToLoad = sqlFirewallClassNames.toString();
        InjectedClassesManagerNew.debug("==> sqlFirewallClassNames: " + sqlFirewallClassNames);
        String tagSQLFirewallManager = null;
        tagSQLFirewallManager = sqlFirewallClassNames.size() < 2 ? " SQLFirewallManager class: " : " SQLFirewallManager classes: ";
        if (!sqlFirewallClassNames.isEmpty()) {
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " " + database + " Database - Loading " + tagSQLFirewallManager);
        }
        SqlFirewallsCreator sqlFirewallsCreator = new SqlFirewallsCreator(sqlFirewallClassNames);
        Set<SqlFirewallManager> sqlFirewallManagers = sqlFirewallsCreator.getSqlFirewalls();
        for (SqlFirewallManager sqlFirewallManager : sqlFirewallManagers) {
            InjectedClassesManagerNew.debug("==> sqlFirewallManager: " + sqlFirewallManager);
        }
        sqlFirewallClassNames = sqlFirewallsCreator.getSqlFirewallClassNames();
        this.classNameToLoad = sqlFirewallClassNames.toString();
        for (String sqlFirewallClassName : sqlFirewallClassNames) {
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> " + sqlFirewallClassName);
        }
        return sqlFirewallManagers;
    }

    private DatabaseConfigurator loadDatabaseConfigurator(String database) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, SQLException {
        String databaseConfiguratorClassName = ConfPropertiesStore.get().getDatabaseConfiguratorClassName(database);
        InjectedClassesManagerNew.debug("databaseConfiguratorClassName    : " + databaseConfiguratorClassName);
        this.classNameToLoad = databaseConfiguratorClassName;
        DatabaseConfiguratorCreator databaseConfiguratorCreator = new DatabaseConfiguratorCreator(databaseConfiguratorClassName);
        DatabaseConfigurator databaseConfigurator = databaseConfiguratorCreator.getDatabaseConfigurator();
        databaseConfiguratorClassName = databaseConfiguratorCreator.getDatabaseConfiguratorClassName();
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " " + database + " Database - Loading DatabaseConfigurator class:");
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> " + databaseConfiguratorClassName);
        return databaseConfigurator;
    }

    public static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + InjectedClassesManagerNew.class.getSimpleName() + " " + s);
        }
    }
}

