/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.injection.classes.creator;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.kawanfw.sql.api.server.DatabaseConfigurationException;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.DefaultDatabaseConfigurator;
import org.kawanfw.sql.util.Tag;
import org.slf4j.Logger;

public class DatabaseConfiguratorCreator {
    private String databaseConfiguratorClassName = null;
    private DatabaseConfigurator databaseConfigurator = null;

    public DatabaseConfiguratorCreator(String theDatabaseConfiguratorClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Logger c;
        if (theDatabaseConfiguratorClassName != null && !theDatabaseConfiguratorClassName.isEmpty()) {
            c = Class.forName(theDatabaseConfiguratorClassName);
            Constructor<?> constructor = c.getConstructor(new Class[0]);
            this.databaseConfigurator = (DatabaseConfigurator)constructor.newInstance(new Object[0]);
            this.databaseConfiguratorClassName = theDatabaseConfiguratorClassName;
        } else {
            this.databaseConfigurator = new DefaultDatabaseConfigurator();
            this.databaseConfiguratorClassName = this.databaseConfigurator.getClass().getName();
        }
        try {
            c = this.databaseConfigurator.getLogger();
        }
        catch (Exception e) {
            throw new DatabaseConfigurationException(String.valueOf(Tag.PRODUCT_USER_CONFIG_FAIL) + " Impossible to get the Logger from DatabaseConfigurator instance", e);
        }
    }

    public String getDatabaseConfiguratorClassName() {
        return this.databaseConfiguratorClassName;
    }

    public DatabaseConfigurator getDatabaseConfigurator() {
        return this.databaseConfigurator;
    }
}

