/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.injection.classes.creator;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import org.kawanfw.sql.api.server.firewall.CsvRulesManager;
import org.kawanfw.sql.api.server.firewall.CsvRulesManagerNoReload;
import org.kawanfw.sql.api.server.firewall.DenyDatabaseWriteManager;
import org.kawanfw.sql.api.server.firewall.DenyDclManager;
import org.kawanfw.sql.api.server.firewall.DenyDdlManager;
import org.kawanfw.sql.api.server.firewall.DenyExceptOnWhitelistManager;
import org.kawanfw.sql.api.server.firewall.DenyMetadataQueryManager;
import org.kawanfw.sql.api.server.firewall.DenyOnBlacklistManager;
import org.kawanfw.sql.api.server.firewall.DenySqlInjectionManager;
import org.kawanfw.sql.api.server.firewall.DenySqlInjectionManagerAsync;
import org.kawanfw.sql.api.server.firewall.DenyStatementClassManager;
import org.kawanfw.sql.api.server.firewall.SqlFirewallManager;
import org.kawanfw.sql.util.FrameworkDebug;

public class SqlFirewallsCreator {
    private static boolean DEBUG = FrameworkDebug.isSet(SqlFirewallsCreator.class);
    private static String[] PREDEFINED_CLASS_NAMES = new String[]{CsvRulesManager.class.getSimpleName(), CsvRulesManagerNoReload.class.getSimpleName(), DenyDclManager.class.getSimpleName(), DenyDdlManager.class.getSimpleName(), DenyDatabaseWriteManager.class.getSimpleName(), DenyExceptOnWhitelistManager.class.getSimpleName(), DenyOnBlacklistManager.class.getSimpleName(), DenyMetadataQueryManager.class.getSimpleName(), DenyStatementClassManager.class.getSimpleName(), DenySqlInjectionManager.class.getSimpleName(), DenySqlInjectionManagerAsync.class.getSimpleName()};
    private Set<String> sqlFirewallClassNames = new LinkedHashSet<String>();
    private Set<SqlFirewallManager> sqlFirewallManagers = new LinkedHashSet<SqlFirewallManager>();

    public SqlFirewallsCreator(Set<String> sqlFirewallClassNames) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException, IOException {
        if (sqlFirewallClassNames != null && !sqlFirewallClassNames.isEmpty()) {
            this.debug("sqlFirewallClassNames: " + sqlFirewallClassNames);
            for (String sqlFirewallClassName : sqlFirewallClassNames) {
                sqlFirewallClassName = sqlFirewallClassName.trim();
                sqlFirewallClassName = SqlFirewallsCreator.getNameWithPackage(sqlFirewallClassName);
                this.debug("");
                this.debug("sqlFirewallClassName with Package to load: " + sqlFirewallClassName + ":");
                Class<?> c = Class.forName(sqlFirewallClassName);
                Constructor<?> constructor = c.getConstructor(new Class[0]);
                SqlFirewallManager sqlFirewallManager = (SqlFirewallManager)constructor.newInstance(new Object[0]);
                this.debug("sqlFirewallManager implementation loaded: " + sqlFirewallClassName);
                sqlFirewallClassName = sqlFirewallManager.getClass().getName();
                this.sqlFirewallManagers.add(sqlFirewallManager);
                this.sqlFirewallClassNames.add(sqlFirewallClassName);
            }
            this.debug("End loop on sqlFirewallClassNames");
        }
    }

    private static String getNameWithPackage(String theClassName) {
        int i = 0;
        while (i < PREDEFINED_CLASS_NAMES.length) {
            if (PREDEFINED_CLASS_NAMES[i].equals(theClassName)) {
                String theClassNameNew = String.valueOf(SqlFirewallManager.class.getPackage().getName()) + "." + theClassName;
                return theClassNameNew;
            }
            ++i;
        }
        return theClassName;
    }

    public Set<SqlFirewallManager> getSqlFirewalls() {
        return this.sqlFirewallManagers;
    }

    public Set<String> getSqlFirewallClassNames() {
        return this.sqlFirewallClassNames;
    }

    public void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

