/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.injection.classes.validator;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.SynchronousQueue;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileUtil;
import org.kawanfw.sql.util.SqlTag;
import org.kawanfw.sql.util.Tag;

public class ThreadPoolCapacityWarner {
    public static String CR_LF = System.getProperty("line.separator");
    private static final int MAX_QUEUE_CAPACITY_RECOMMANDED = 100;
    private static final String WARNING_SECOND_LINE_SPACES = "         ";
    private String propertiesFile;

    public ThreadPoolCapacityWarner(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public void warnOnThreadPoolExecutorParams() throws IOException {
        File file = new File(this.propertiesFile);
        Properties properties = PropertiesFileUtil.getProperties(file);
        this.treatCapacityWarningMessage(properties);
    }

    public void treatCapacityWarningMessage(Properties properties) throws NumberFormatException {
        String workQueueClassName = properties.getProperty("workQueueClassName");
        if (workQueueClassName != null && !workQueueClassName.equals(SynchronousQueue.class.getName())) {
            String capcacityStr = properties.getProperty("capacity");
            if (capcacityStr == null || capcacityStr.isEmpty()) {
                return;
            }
            int capacity = Integer.parseInt(capcacityStr);
            if (capacity > 100) {
                System.err.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " " + Tag.WARNING + " The ThreadPoolExecutor Queue \"" + "capacity" + "\" property" + " should not be > " + 100 + CR_LF + SqlTag.SQL_PRODUCT_START + WARNING_SECOND_LINE_SPACES + " " + " because of a potential SQL run bottleneck. (Set value in .properties file: " + capacity + ")");
            }
        }
    }
}

