/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.injection.properties;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.iv.IvGenerator;
import org.jasypt.iv.RandomIvGenerator;
import org.kawanfw.sql.util.FrameworkDebug;

public class AdvancedPropertiesDecryptorWrap {
    private static boolean DEBUG = FrameworkDebug.isSet(AdvancedPropertiesDecryptorWrap.class);

    public static Properties decrypt(Properties properties, char[] password) throws IOException {
        String value;
        String key;
        Objects.requireNonNull(properties, "properties cannot be null!");
        Objects.requireNonNull(password, "password cannot be null!");
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setPassword(new String(password));
        encryptor.setAlgorithm("PBEWithHMACSHA512AndAES_256");
        encryptor.setIvGenerator((IvGenerator)new RandomIvGenerator());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            if (value == null || !value.trim().startsWith("ENC(") || !value.trim().endsWith(")")) continue;
            value = value.trim();
            value = StringUtils.substringAfter((String)value, (String)"ENC(");
            value = StringUtils.substringBeforeLast((String)value, (String)")");
            value = encryptor.decrypt(value).trim();
            properties.setProperty(key, value);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            if (!key.contains("password")) continue;
            AdvancedPropertiesDecryptorWrap.debug("key / value: " + key + " / " + value);
        }
        return properties;
    }

    private static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + AdvancedPropertiesDecryptorWrap.class.getSimpleName() + " " + s);
        }
    }
}

