/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.injection.properties;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.kawanfw.sql.servlet.injection.properties.OperationalMode;

public class ConfProperties {
    private Set<String> databaseSet = null;
    private Map<String, String> databaseConfiguratorClassNameMap = new ConcurrentHashMap<String, String>();
    private String servletCallName = null;
    private String blobDownloadConfiguratorClassName = null;
    private String blobUploadConfiguratorClassName = null;
    private String userAuthenticatorClassName = null;
    private String requestHeadersAuthenticatorClassName = null;
    private String sessionConfiguratorClassName = null;
    private String jwtSessionConfiguratorSecretValue = null;
    private Set<String> userServlets = new HashSet<String>();
    private Map<String, Set<String>> sqlFirewallManagerClassNamesMap = new ConcurrentHashMap<String, Set<String>>();
    private boolean statelessMode;
    private Map<String, Set<String>> sqlFirewallTriggerClassNamesMap = new ConcurrentHashMap<String, Set<String>>();
    private Map<String, Set<String>> updateListenerClassNamesMap = new ConcurrentHashMap<String, Set<String>>();
    private Map<String, OperationalMode> operationalModeMap = new ConcurrentHashMap<String, OperationalMode>();

    private ConfProperties(ConfPropertiesBuilder confPropertiesBuilder) {
        this.databaseSet = confPropertiesBuilder.databaseSet;
        this.databaseConfiguratorClassNameMap = confPropertiesBuilder.databaseConfiguratorClassNameMap;
        this.servletCallName = confPropertiesBuilder.servletCallName;
        this.blobDownloadConfiguratorClassName = confPropertiesBuilder.blobDownloadConfiguratorClassName;
        this.blobUploadConfiguratorClassName = confPropertiesBuilder.blobUploadConfiguratorClassName;
        this.userAuthenticatorClassName = confPropertiesBuilder.userAuthenticatorClassName;
        this.requestHeadersAuthenticatorClassName = confPropertiesBuilder.requestHeadersAuthenticatorClassName;
        this.sessionConfiguratorClassName = confPropertiesBuilder.sessionConfiguratorClassName;
        this.jwtSessionConfiguratorSecretValue = confPropertiesBuilder.jwtSessionConfiguratorSecretValue;
        this.userServlets = confPropertiesBuilder.userServlets;
        this.sqlFirewallManagerClassNamesMap = confPropertiesBuilder.sqlFirewallManagerClassNamesMap;
        this.statelessMode = confPropertiesBuilder.statelessMode;
        this.sqlFirewallTriggerClassNamesMap = confPropertiesBuilder.sqlFirewallTriggerClassNamesMap;
        this.updateListenerClassNamesMap = confPropertiesBuilder.updateListenerClassNamesMap;
        this.operationalModeMap = confPropertiesBuilder.operationalModeMap;
    }

    public Set<String> getDatabaseNames() {
        return this.databaseSet;
    }

    private Map<String, String> getDatabaseConfiguratorClassNameMap() {
        return this.databaseConfiguratorClassNameMap;
    }

    public String getDatabaseConfiguratorClassName(String database) {
        return this.databaseConfiguratorClassNameMap.get(database);
    }

    public String getServletCallName() {
        return this.servletCallName;
    }

    public String getBlobDownloadConfiguratorClassName() {
        return this.blobDownloadConfiguratorClassName;
    }

    public String getBlobUploadConfiguratorClassName() {
        return this.blobUploadConfiguratorClassName;
    }

    public String getUserAuthenticatorClassName() {
        return this.userAuthenticatorClassName;
    }

    public String getRequestHeadersAuthenticatorClassName() {
        return this.requestHeadersAuthenticatorClassName;
    }

    public String getSessionConfiguratorClassName() {
        return this.sessionConfiguratorClassName;
    }

    public String getJwtSessionConfiguratorSecretValue() {
        return this.jwtSessionConfiguratorSecretValue;
    }

    public Set<String> getUserServlets() {
        return this.userServlets;
    }

    private Map<String, Set<String>> getSqlFirewallManagerClassNamesMap() {
        return this.sqlFirewallManagerClassNamesMap;
    }

    public Set<String> getSqlFirewallManagerClassNames(String database) {
        return this.sqlFirewallManagerClassNamesMap.get(database);
    }

    public Set<String> getSqlFirewallTriggerClassNames(String database) {
        return this.sqlFirewallTriggerClassNamesMap.get(database);
    }

    public boolean isStatelessMode() {
        return this.statelessMode;
    }

    public Map<String, OperationalMode> getOperationalModeMap() {
        return this.operationalModeMap;
    }

    public OperationalMode getOperationalModeMap(String database) {
        Objects.requireNonNull(database, "database cannnot be null!");
        return this.operationalModeMap.get(database);
    }

    private Map<String, Set<String>> getSqlFirewallTriggerClassNamesMap() {
        return this.sqlFirewallTriggerClassNamesMap;
    }

    private Map<String, Set<String>> getUpdateListenerClassNamesMap() {
        return this.updateListenerClassNamesMap;
    }

    public Set<String> getUpdateListenerClassNames(String database) {
        return this.updateListenerClassNamesMap.get(database);
    }

    /* synthetic */ ConfProperties(ConfPropertiesBuilder confPropertiesBuilder, ConfProperties confProperties) {
        this(confPropertiesBuilder);
    }

    public static class ConfPropertiesBuilder {
        private Set<String> databaseSet = null;
        private Map<String, String> databaseConfiguratorClassNameMap = new ConcurrentHashMap<String, String>();
        private String servletCallName = null;
        private String blobDownloadConfiguratorClassName = null;
        private String blobUploadConfiguratorClassName = null;
        private String userAuthenticatorClassName = null;
        private String requestHeadersAuthenticatorClassName = null;
        private String sessionConfiguratorClassName = null;
        private String jwtSessionConfiguratorSecretValue = null;
        private Set<String> userServlets = new HashSet<String>();
        private Map<String, Set<String>> sqlFirewallManagerClassNamesMap = new ConcurrentHashMap<String, Set<String>>();
        private boolean statelessMode;
        private Map<String, Set<String>> sqlFirewallTriggerClassNamesMap = new ConcurrentHashMap<String, Set<String>>();
        private Map<String, Set<String>> updateListenerClassNamesMap = new ConcurrentHashMap<String, Set<String>>();
        private Map<String, OperationalMode> operationalModeMap = new ConcurrentHashMap<String, OperationalMode>();

        public ConfPropertiesBuilder databaseSet(Set<String> databaseSet) {
            this.databaseSet = databaseSet;
            return this;
        }

        public ConfPropertiesBuilder databaseConfiguratorClassNameMap(Map<String, String> databaseConfiguratorClassNameMap) {
            this.databaseConfiguratorClassNameMap = databaseConfiguratorClassNameMap;
            return this;
        }

        public ConfPropertiesBuilder servletCallName(String servletCallName) {
            this.servletCallName = servletCallName;
            return this;
        }

        public ConfPropertiesBuilder blobDownloadConfiguratorClassName(String blobDownloadConfiguratorClassName) {
            this.blobDownloadConfiguratorClassName = blobDownloadConfiguratorClassName;
            return this;
        }

        public ConfPropertiesBuilder blobUploadConfiguratorClassName(String blobUploadConfiguratorClassName) {
            this.blobUploadConfiguratorClassName = blobUploadConfiguratorClassName;
            return this;
        }

        public ConfPropertiesBuilder userAuthenticatorClassName(String userAuthenticatorClassName) {
            this.userAuthenticatorClassName = userAuthenticatorClassName;
            return this;
        }

        public ConfPropertiesBuilder requestHeadersAuthenticatorClassName(String requestHeadersAuthenticatorClassName) {
            this.requestHeadersAuthenticatorClassName = requestHeadersAuthenticatorClassName;
            return this;
        }

        public ConfPropertiesBuilder sessionConfiguratorClassName(String sessionConfiguratorClassName) {
            this.sessionConfiguratorClassName = sessionConfiguratorClassName;
            return this;
        }

        public ConfPropertiesBuilder jwtSessionConfiguratorSecretValue(String jwtSessionConfiguratorSecretValue) {
            this.jwtSessionConfiguratorSecretValue = jwtSessionConfiguratorSecretValue;
            return this;
        }

        public ConfPropertiesBuilder userServlets(Set<String> userServlets) {
            this.userServlets = userServlets;
            return this;
        }

        public ConfPropertiesBuilder sqlFirewallManagerClassNamesMap(Map<String, Set<String>> sqlFirewallManagerClassNamesMap) {
            this.sqlFirewallManagerClassNamesMap = sqlFirewallManagerClassNamesMap;
            return this;
        }

        public ConfPropertiesBuilder sqlFirewallTriggerClassNamesMap(Map<String, Set<String>> sqlFirewallTriggerClassNamesMap) {
            this.sqlFirewallTriggerClassNamesMap = sqlFirewallTriggerClassNamesMap;
            return this;
        }

        public ConfPropertiesBuilder updateListenerClassNamesMap(Map<String, Set<String>> updateListenerClassNamesMap) {
            this.updateListenerClassNamesMap = updateListenerClassNamesMap;
            return this;
        }

        public ConfPropertiesBuilder statelessMode(boolean statelessMode) {
            this.statelessMode = statelessMode;
            return this;
        }

        public ConfPropertiesBuilder operationalModeMap(Map<String, OperationalMode> operationalModeMap) {
            this.operationalModeMap = operationalModeMap;
            return this;
        }

        public ConfProperties build() {
            ConfProperties confProperties = new ConfProperties(this, null);
            return confProperties;
        }

        private void validateUserObject(ConfProperties confProperties) {
        }
    }
}

