/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.injection.properties;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.kawanfw.sql.servlet.injection.properties.AdvancedServletAceQLCallNameGetter;
import org.kawanfw.sql.servlet.injection.properties.ConfProperties;
import org.kawanfw.sql.servlet.injection.properties.OperationalMode;
import org.kawanfw.sql.tomcat.TomcatStarterUtil;
import org.kawanfw.sql.tomcat.TomcatStarterUtilProperties;
import org.kawanfw.sql.util.FrameworkDebug;

public class ConfPropertiesManager {
    private static boolean DEBUG = FrameworkDebug.isSet(ConfPropertiesManager.class);
    private Properties properties;

    public ConfPropertiesManager(Properties properties) {
        this.properties = Objects.requireNonNull(properties, "properties cannot be null!");
    }

    public ConfProperties createConfProperties() throws IOException, SQLException {
        String requestHeadersAuthenticatorClassName;
        ConfProperties.ConfPropertiesBuilder confPropertiesBuilder = new ConfProperties.ConfPropertiesBuilder();
        AdvancedServletAceQLCallNameGetter advancedServletAceQLCallNameGetter = new AdvancedServletAceQLCallNameGetter();
        String aceQLManagerServletCallName = advancedServletAceQLCallNameGetter.getName();
        this.debug("aceQLManagerServletCallName: " + aceQLManagerServletCallName);
        confPropertiesBuilder.servletCallName(aceQLManagerServletCallName);
        boolean statelessMode = Boolean.parseBoolean(this.properties.getProperty("statelessMode", "false"));
        confPropertiesBuilder.statelessMode(statelessMode);
        Set<String> databases = TomcatStarterUtil.getDatabaseNames(this.properties);
        confPropertiesBuilder.databaseSet(databases);
        String userAuthenticatorClassName = TomcatStarterUtil.trimSafe(this.properties.getProperty("userAuthenticatorClassName"));
        if (userAuthenticatorClassName != null && !userAuthenticatorClassName.isEmpty()) {
            confPropertiesBuilder.userAuthenticatorClassName(userAuthenticatorClassName);
        }
        if ((requestHeadersAuthenticatorClassName = TomcatStarterUtil.trimSafe(this.properties.getProperty("requestHeadersAuthenticatorClassName"))) != null && !requestHeadersAuthenticatorClassName.isEmpty()) {
            confPropertiesBuilder.requestHeadersAuthenticatorClassName(requestHeadersAuthenticatorClassName);
        }
        HashMap<String, String> databaseConfiguratorClassNameMap = new HashMap<String, String>();
        ConcurrentHashMap<String, Set<String>> sqlFirewallClassNamesMap = new ConcurrentHashMap<String, Set<String>>();
        ConcurrentHashMap<String, Set<String>> sqlFirewallTriggerClassNamesMap = new ConcurrentHashMap<String, Set<String>>();
        ConcurrentHashMap<String, Set<String>> updateListenerClassNamesMap = new ConcurrentHashMap<String, Set<String>>();
        LinkedHashMap<String, OperationalMode> operationalModeMap = new LinkedHashMap<String, OperationalMode>();
        this.buildObjectsPerDatabase(databases, databaseConfiguratorClassNameMap, sqlFirewallClassNamesMap, sqlFirewallTriggerClassNamesMap, updateListenerClassNamesMap, operationalModeMap);
        confPropertiesBuilder.databaseConfiguratorClassNameMap(databaseConfiguratorClassNameMap);
        confPropertiesBuilder.sqlFirewallManagerClassNamesMap(sqlFirewallClassNamesMap);
        confPropertiesBuilder.sqlFirewallTriggerClassNamesMap(sqlFirewallTriggerClassNamesMap);
        confPropertiesBuilder.operationalModeMap(operationalModeMap);
        if (DEBUG) {
            System.out.println("sqlFirewallTriggerClassNamesMap: " + sqlFirewallTriggerClassNamesMap);
        }
        confPropertiesBuilder.updateListenerClassNamesMap(updateListenerClassNamesMap);
        String blobDownloadConfiguratorClassName = TomcatStarterUtil.trimSafe(this.properties.getProperty("blobDownloadConfiguratorClassName"));
        confPropertiesBuilder.blobDownloadConfiguratorClassName(blobDownloadConfiguratorClassName);
        String blobUploadConfiguratorClassName = TomcatStarterUtil.trimSafe(this.properties.getProperty("blobUploadConfiguratorClassName"));
        confPropertiesBuilder.blobUploadConfiguratorClassName(blobUploadConfiguratorClassName);
        String sessionConfiguratorClassName = TomcatStarterUtil.trimSafe(this.properties.getProperty("sessionConfiguratorClassName"));
        confPropertiesBuilder.sessionConfiguratorClassName(sessionConfiguratorClassName);
        String jwtSessionConfiguratorSecretValue = TomcatStarterUtil.trimSafe(this.properties.getProperty("jwtSessionConfiguratorSecret"));
        confPropertiesBuilder.jwtSessionConfiguratorSecretValue(jwtSessionConfiguratorSecretValue);
        ConfProperties confProperties = confPropertiesBuilder.build();
        return confProperties;
    }

    private void debug(String s) {
        if (DEBUG) {
            System.out.println(String.valueOf(this.getClass().getSimpleName()) + " " + new Date() + " " + s);
        }
    }

    public void buildObjectsPerDatabase(Set<String> databases, Map<String, String> databaseConfiguratorClassNameMap, Map<String, Set<String>> sqlFirewallClassNamesMap, Map<String, Set<String>> sqlFirewallTriggerClassNamesMap, Map<String, Set<String>> updateListenerClassNamesMap, Map<String, OperationalMode> operationalModeMap) {
        for (String database : databases) {
            String sqlFirewallClassNameArray;
            String databaseConfiguratorClassName = TomcatStarterUtil.trimSafe(this.properties.getProperty(String.valueOf(database) + "." + "databaseConfiguratorClassName"));
            if (databaseConfiguratorClassName != null && !databaseConfiguratorClassName.isEmpty()) {
                databaseConfiguratorClassNameMap.put(database, databaseConfiguratorClassName);
            }
            if ((sqlFirewallClassNameArray = TomcatStarterUtil.trimSafe(this.properties.getProperty(String.valueOf(database) + "." + "sqlFirewallManagerClassNames"))) != null && !sqlFirewallClassNameArray.isEmpty()) {
                List<String> sqlFirewallClassNamesList = TomcatStarterUtilProperties.getList(sqlFirewallClassNameArray);
                LinkedHashSet<String> sqlFirewallClassNames = new LinkedHashSet<String>(sqlFirewallClassNamesList);
                sqlFirewallClassNamesMap.put(database, sqlFirewallClassNames);
            } else {
                sqlFirewallClassNamesMap.put(database, new LinkedHashSet());
            }
            String sqlFirewallTriggerClassNameArray = TomcatStarterUtil.trimSafe(this.properties.getProperty(String.valueOf(database) + "." + "sqlFirewallTriggerClassNames"));
            if (sqlFirewallTriggerClassNameArray != null && !sqlFirewallTriggerClassNameArray.isEmpty()) {
                List<String> sqlFirewallTriggerClassNamesList = TomcatStarterUtilProperties.getList(sqlFirewallTriggerClassNameArray);
                LinkedHashSet<String> sqlFirewallTriggerClassNames = new LinkedHashSet<String>(sqlFirewallTriggerClassNamesList);
                sqlFirewallTriggerClassNamesMap.put(database, sqlFirewallTriggerClassNames);
            } else {
                sqlFirewallTriggerClassNamesMap.put(database, new LinkedHashSet());
            }
            String updateListenerClassNameArray = TomcatStarterUtil.trimSafe(this.properties.getProperty(String.valueOf(database) + "." + "updateListenerClassNames"));
            if (updateListenerClassNameArray != null && !updateListenerClassNameArray.isEmpty()) {
                List<String> updateListenerClassNamesList = TomcatStarterUtilProperties.getList(updateListenerClassNameArray);
                LinkedHashSet<String> updateListenerClassNames = new LinkedHashSet<String>(updateListenerClassNamesList);
                updateListenerClassNamesMap.put(database, updateListenerClassNames);
            } else {
                updateListenerClassNamesMap.put(database, new LinkedHashSet());
            }
            String operationalMode = TomcatStarterUtil.trimSafe(this.properties.getProperty(String.valueOf(database) + "." + "operationalMode"));
            if (operationalMode == null || operationalMode.isEmpty()) {
                operationalMode = OperationalMode.protecting.toString();
            }
            try {
                OperationalMode operationalModeEnum = OperationalMode.valueOf(operationalMode);
                operationalModeMap.put(database, operationalModeEnum);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("[USER CONFIGURATION] the " + database + ".operationalMode property value is invalid: " + operationalMode + ".  Please correct. ");
            }
        }
    }
}

