/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.injection.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.kawanfw.sql.api.server.DatabaseConfigurationException;
import org.kawanfw.sql.api.server.auth.crypto.PropertiesPasswordManager;
import org.kawanfw.sql.servlet.injection.properties.AdvancedPropertiesDecryptorWrap;
import org.kawanfw.sql.servlet.injection.properties.PropertiesPasswordManagerLoader;
import org.kawanfw.sql.tomcat.util.LinkedProperties;
import org.kawanfw.sql.util.FrameworkDebug;

public class PropertiesFileUtil {
    private static boolean DEBUG = FrameworkDebug.isSet(PropertiesFileUtil.class);

    public static Properties getProperties(File file) throws IOException {
        Properties properties = PropertiesFileUtil.commonsGetProperties(file);
        PropertiesFileUtil.debug("Before EditionUtil.isCommunityEdition()");
        PropertiesFileUtil.debug("After EditionUtil.isCommunityEdition()");
        PropertiesFileUtil.debug("Properties file: " + file);
        char[] password = null;
        try {
            password = PropertiesPasswordManagerLoader.getPassword(properties);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DatabaseConfigurationException(e.getMessage());
        }
        if (password == null) {
            PropertiesFileUtil.debug("Password is null! No Decryption to do.");
            return properties;
        }
        try {
            properties = AdvancedPropertiesDecryptorWrap.decrypt(properties, password);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!key.contains("password")) continue;
                PropertiesFileUtil.debug(" In getProperties: --> key / value: " + key + " / " + value);
            }
            return properties;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new IOException("Can not load ProEditionPropertiesDecryptor", e);
        }
    }

    public static char[] getPassword(Properties properties) throws IOException, SQLException {
        Objects.requireNonNull(properties, "properties cannot be null!");
        String propertiesPasswordManagerClassName = properties.getProperty("propertiesPasswordManagerClassName");
        if (propertiesPasswordManagerClassName == null || propertiesPasswordManagerClassName.isEmpty()) {
            return null;
        }
        PropertiesPasswordManager propertiesPasswordManager = null;
        try {
            Class<?> c = Class.forName(propertiesPasswordManagerClassName);
            Constructor<?> constructor = c.getConstructor(new Class[0]);
            propertiesPasswordManager = (PropertiesPasswordManager)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            String initErrrorMesage = "Impossible to load PropertiesPasswordManager concrete class: " + propertiesPasswordManagerClassName;
            e.printStackTrace();
            throw new DatabaseConfigurationException(initErrrorMesage);
        }
        return propertiesPasswordManager.getPassword();
    }

    public static Properties commonsGetProperties(File file) throws IllegalArgumentException, DatabaseConfigurationException, IOException, FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file can not be null!");
        }
        if (!file.exists()) {
            throw new DatabaseConfigurationException("properties file not found: " + file);
        }
        Set<String> linkedProperties = LinkedProperties.getLinkedPropertiesName(file);
        Properties properties = new Properties();
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream in = new FileInputStream(file);){
            properties = new LinkedProperties(linkedProperties);
            properties.load(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return properties;
    }

    private static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + PropertiesFileUtil.class.getSimpleName() + " " + s);
        }
    }
}

