/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.injection.properties;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;
import org.kawanfw.sql.api.server.DatabaseConfigurationException;
import org.kawanfw.sql.api.server.auth.crypto.DefaultPropertiesPasswordManager;
import org.kawanfw.sql.api.server.auth.crypto.PropertiesPasswordManager;
import org.kawanfw.sql.util.FrameworkDebug;

public class PropertiesPasswordManagerLoader {
    private static boolean DEBUG = FrameworkDebug.isSet(PropertiesPasswordManagerLoader.class);

    public static char[] getPassword(Properties properties) throws IOException, SQLException {
        Objects.requireNonNull(properties, "properties cannot be null!");
        String propertiesPasswordManagerClassName = properties.getProperty("propertiesPasswordManagerClassName");
        if (propertiesPasswordManagerClassName == null || propertiesPasswordManagerClassName.trim().isEmpty()) {
            propertiesPasswordManagerClassName = DefaultPropertiesPasswordManager.class.getName();
        }
        PropertiesPasswordManagerLoader.debug("Before Class<?> c = Class.forName(propertiesPasswordManagerClassName);");
        PropertiesPasswordManager propertiesPasswordManager = null;
        try {
            Class<?> c = Class.forName(propertiesPasswordManagerClassName);
            Constructor<?> constructor = c.getConstructor(new Class[0]);
            propertiesPasswordManager = (PropertiesPasswordManager)constructor.newInstance(new Object[0]);
            PropertiesPasswordManagerLoader.debug("After (PropertiesPasswordManager) constructor.newInstance()");
        }
        catch (Exception e) {
            String initErrrorMesage = "Impossible to load PropertiesPasswordManager concrete class: " + propertiesPasswordManagerClassName;
            e.printStackTrace();
            throw new DatabaseConfigurationException(initErrrorMesage);
        }
        char[] password = propertiesPasswordManager.getPassword();
        if (password == null) {
            PropertiesPasswordManagerLoader.debug("password is null!");
        } else {
            PropertiesPasswordManagerLoader.debug("password: " + new String(password));
        }
        return password;
    }

    private static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + PropertiesPasswordManagerLoader.class.getSimpleName() + " " + s);
        }
    }
}

