/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.jdbc.metadata;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.kawanfw.sql.jdbc.metadata.ArrayTransporter;
import org.kawanfw.sql.util.FrameworkDebug;

public class DatabaseMetaDataSpecialExecutor {
    private static boolean DEBUG = FrameworkDebug.isSet(DatabaseMetaDataSpecialExecutor.class);
    private DatabaseMetaData databaseMetaData = null;
    private String methodName = null;
    private List<String> listParamsValues = null;

    public DatabaseMetaDataSpecialExecutor(DatabaseMetaData databaseMetaData, String methodName, List<String> listParamsValues) {
        if (databaseMetaData == null) {
            throw new IllegalArgumentException("databaseMetaData can not be null!");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("methodName can not be null!");
        }
        if (listParamsValues == null) {
            throw new IllegalArgumentException("listParamsValues can not be null!");
        }
        this.databaseMetaData = databaseMetaData;
        this.methodName = methodName;
        this.listParamsValues = listParamsValues;
    }

    public ResultSet execute() throws SQLException {
        ResultSet rs = null;
        if (this.methodName.equals("getTables")) {
            rs = this.executeGetTables();
        } else if (this.methodName.equals("getUDTs")) {
            rs = this.executeGetUDTs();
        } else if (this.methodName.equals("getPrimaryKeys")) {
            rs = this.executeGetPrimaryKeys();
        } else {
            throw new IllegalArgumentException("Invalid DatabaseMetaData method name. Must be \"getTables\" or \"getUDTs\" or \"getPrimaryKeys\": " + this.methodName);
        }
        return rs;
    }

    private ResultSet executeGetTables() throws SQLException {
        String catalog = this.listParamsValues.get(0);
        String schemaPattern = this.listParamsValues.get(1);
        String tableNamePattern = this.listParamsValues.get(2);
        String join = this.listParamsValues.get(3);
        DatabaseMetaDataSpecialExecutor.debug("catalog          : " + catalog + ":");
        DatabaseMetaDataSpecialExecutor.debug("schemaPattern    : " + schemaPattern + ":");
        DatabaseMetaDataSpecialExecutor.debug("tableNamePattern : " + tableNamePattern + ":");
        DatabaseMetaDataSpecialExecutor.debug("join             : " + join + ":");
        String[] types = ArrayTransporter.stringToStringArray(join);
        if (catalog.equals("NULL")) {
            catalog = null;
        }
        if (schemaPattern.equals("NULL")) {
            schemaPattern = null;
        }
        if (tableNamePattern.equals("NULL")) {
            tableNamePattern = null;
        }
        if (types != null && types.length == 1 && types[0].equals("NULL")) {
            types = null;
        }
        ResultSet rsMetaTables = this.databaseMetaData.getTables(catalog, schemaPattern, tableNamePattern, types);
        return rsMetaTables;
    }

    private ResultSet executeGetUDTs() throws SQLException {
        String catalog = this.listParamsValues.get(0);
        String schemaPattern = this.listParamsValues.get(1);
        String tableNamePattern = this.listParamsValues.get(2);
        String join = this.listParamsValues.get(3);
        int[] types = ArrayTransporter.stringToIntArray(join);
        if (catalog.equals("NULL")) {
            catalog = null;
        }
        if (schemaPattern.equals("NULL")) {
            schemaPattern = null;
        }
        if (tableNamePattern.equals("NULL")) {
            tableNamePattern = null;
        }
        if (types != null && types.length == 1 && types[0] == -999) {
            types = null;
        }
        ResultSet rs = this.databaseMetaData.getUDTs(catalog, schemaPattern, tableNamePattern, types);
        return rs;
    }

    private ResultSet executeGetPrimaryKeys() throws SQLException {
        String catalog = this.listParamsValues.get(0);
        String schemaPattern = this.listParamsValues.get(1);
        String tableNamePattern = this.listParamsValues.get(2);
        if (catalog.equals("NULL")) {
            catalog = null;
        }
        if (schemaPattern.equals("NULL")) {
            schemaPattern = null;
        }
        if (tableNamePattern.equals("NULL")) {
            tableNamePattern = null;
        }
        ResultSet rs = this.databaseMetaData.getPrimaryKeys(catalog, schemaPattern, tableNamePattern);
        return rs;
    }

    public static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

