/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.jdbc.metadata;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.kawanfw.sql.api.server.firewall.SqlFirewallManager;
import org.kawanfw.sql.jdbc.metadata.DatabaseMetaDataMethodCallDTO;
import org.kawanfw.sql.metadata.util.GsonWsUtil;
import org.kawanfw.sql.servlet.ActionUtil;
import org.kawanfw.sql.servlet.ServerSqlDispatchUtil;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.connection.RollbackUtil;
import org.kawanfw.sql.servlet.jdbc.metadata.JdbcDatabaseMetaDataExecutor;
import org.kawanfw.sql.servlet.sql.json_return.JsonErrorReturn;

public class DefaultJdbcDatabaseMetadataActionManagerWrap {
    public static void executeWrap(HttpServletRequest request, HttpServletResponse response, OutputStream out, Set<SqlFirewallManager> sqlFirewallManagers, Connection connection) throws SQLException, IOException {
        try {
            ServerSqlDispatchUtil.checkMetadataAuthorized(request, connection, sqlFirewallManagers);
            DefaultJdbcDatabaseMetadataActionManagerWrap.executeInTryCatch(request, out, connection);
        }
        catch (SecurityException e) {
            RollbackUtil.rollback(connection);
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 403, 3, e.getMessage());
            ServerSqlManager.writeLine(out, errorReturn.build());
        }
        catch (SQLException e) {
            RollbackUtil.rollback(connection);
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 400, 1, e.getMessage());
            ServerSqlManager.writeLine(out, errorReturn.build());
        }
        catch (Exception e) {
            RollbackUtil.rollback(connection);
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 500, 4, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            ServerSqlManager.writeLine(out, errorReturn.build());
        }
    }

    private static void executeInTryCatch(HttpServletRequest request, OutputStream out, Connection connection) throws SQLException, IOException, SecurityException, FileNotFoundException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String action = request.getParameter("action");
        if (!ActionUtil.isJdbcDatabaseMetaDataQuery(action)) {
            throw new IllegalArgumentException("Unknown JDBC DatabaseMetaData query action: " + action);
        }
        String jsonString = request.getParameter("json_database_meta_data_method_call_dto");
        DatabaseMetaDataMethodCallDTO databaseMetaDataMethodCallDTO = GsonWsUtil.fromJson(jsonString, DatabaseMetaDataMethodCallDTO.class);
        JdbcDatabaseMetaDataExecutor jdbcDatabaseMetaDataExecutor = new JdbcDatabaseMetaDataExecutor(request, databaseMetaDataMethodCallDTO, out, connection);
        jdbcDatabaseMetaDataExecutor.callDatabaseMetaDataMethod();
    }
}

