/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.jdbc.metadata;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.servlet.http.HttpServletRequest;
import org.kawanfw.sql.jdbc.metadata.BooleanResponseDTO;
import org.kawanfw.sql.jdbc.metadata.DatabaseMetaDataMethodCallDTO;
import org.kawanfw.sql.metadata.util.GsonWsUtil;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.jdbc.metadata.DatabaseMetaDataSpecialExecutor;
import org.kawanfw.sql.servlet.jdbc.metadata.MethodParametersBuilder;
import org.kawanfw.sql.servlet.sql.ResultSetWriter;
import org.kawanfw.sql.servlet.sql.json_return.JsonUtil;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.Tag;

public class JdbcDatabaseMetaDataExecutor {
    private static boolean DEBUG = FrameworkDebug.isSet(JdbcDatabaseMetaDataExecutor.class);
    private HttpServletRequest request;
    private DatabaseMetaDataMethodCallDTO databaseMetaDataMethodCallDTO;
    private OutputStream out;
    private Connection connection;

    public JdbcDatabaseMetaDataExecutor(HttpServletRequest request, DatabaseMetaDataMethodCallDTO databaseMetaDataMethodCallDTO, OutputStream out, Connection connection) {
        this.request = request;
        this.databaseMetaDataMethodCallDTO = databaseMetaDataMethodCallDTO;
        this.out = out;
        this.connection = connection;
    }

    public void callDatabaseMetaDataMethod() throws SQLException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException {
        Object[] methodParameterValues;
        String methodName = this.databaseMetaDataMethodCallDTO.getMethodName();
        List<String> paramTypes = this.databaseMetaDataMethodCallDTO.getParamTypes();
        List<String> paramsValues = this.databaseMetaDataMethodCallDTO.getParamValues();
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        if (methodName.equals("getTables") || methodName.equals("getUDTs") || methodName.equals("getPrimaryKeys")) {
            DatabaseMetaDataSpecialExecutor databaseMetaDataSpecial = new DatabaseMetaDataSpecialExecutor(databaseMetaData, methodName, paramsValues);
            ResultSet rs = databaseMetaDataSpecial.execute();
            this.dumpResultSetOnServletOutStream(rs);
            return;
        }
        MethodParametersBuilder methodParametersBuilder = new MethodParametersBuilder(paramTypes, paramsValues);
        Class<?>[] methodParameterTypes = methodParametersBuilder.getMethodParamTypes();
        Object resultObj = this.callMethodWithReflection(methodName, databaseMetaData, methodParameterTypes, methodParameterValues = methodParametersBuilder.getMethodParamValues());
        if (resultObj instanceof ResultSet) {
            ResultSet rs = (ResultSet)resultObj;
            this.dumpResultSetOnServletOutStream(rs);
        } else {
            String result = null;
            if (resultObj != null) {
                result = resultObj.toString();
            }
            this.debug("callMethodWithReflection: " + result);
            Boolean booleanResult = Boolean.parseBoolean(result);
            BooleanResponseDTO booleanResponseDTO = new BooleanResponseDTO(booleanResult);
            String jsonString = GsonWsUtil.getJSonString(booleanResponseDTO);
            ServerSqlManager.writeLine(this.out, jsonString);
        }
    }

    private void dumpResultSetOnServletOutStream(ResultSet rs) throws SQLException, IOException {
        boolean doPrettyPrinting = true;
        JsonGeneratorFactory jf = JsonUtil.getJsonGeneratorFactory(doPrettyPrinting);
        JsonGenerator gen = jf.createGenerator(this.out);
        gen.writeStartObject().write("status", "OK");
        boolean fillResultSetMetaData = true;
        ResultSetWriter resultSetWriter = new ResultSetWriter(this.request, "ResultSetMetaData", gen, fillResultSetMetaData);
        resultSetWriter.write(rs);
        ServerSqlManager.writeLine(this.out);
        gen.writeEnd();
        gen.flush();
        gen.close();
    }

    private Object callMethodWithReflection(String methodName, DatabaseMetaData databaseMetaData, Class<?>[] methodParameterTypes, Object[] methodParameterValues) throws ClassNotFoundException, SQLException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> c = Class.forName("java.sql.DatabaseMetaData");
        DatabaseMetaData theObject = databaseMetaData;
        Method main = null;
        Object resultObj = null;
        String database = "";
        String productVersion = "";
        String DriverName = "";
        String DriverVersion = "";
        String driverInfo = Tag.PRODUCT;
        database = databaseMetaData.getDatabaseProductName();
        productVersion = databaseMetaData.getDatabaseProductVersion();
        DriverName = databaseMetaData.getDriverName();
        DriverVersion = databaseMetaData.getDriverVersion();
        driverInfo = String.valueOf(driverInfo) + " " + database + " " + productVersion + " " + DriverName + " " + DriverVersion;
        String methodParams = JdbcDatabaseMetaDataExecutor.getMethodParams(methodParameterValues);
        try {
            main = c.getDeclaredMethod(methodName, methodParameterTypes);
        }
        catch (SecurityException e) {
            throw new SecurityException(String.valueOf(driverInfo) + " - Security - Impossible to get declared DatabaseMetaData." + methodName + "(" + methodParams + ")");
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodException(String.valueOf(driverInfo) + " - No Such Method - Impossible get declared DatabaseMetaData." + methodName + "(" + methodParams + ")");
        }
        try {
            resultObj = main.invoke((Object)theObject, methodParameterValues);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.valueOf(driverInfo) + " - Impossible to call DatabaseMetaData." + methodName + "(" + methodParams + ")");
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessException(String.valueOf(driverInfo) + " - Impossible to access DatabaseMetaData method." + methodName + "(" + methodParams + ")");
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetException(e, String.valueOf(driverInfo) + " - Impossible to invoke DatabaseMetaData method." + methodName + methodParams);
        }
        return resultObj;
    }

    private static String getMethodParams(Object[] values) {
        if (values.length == 0) {
            return "";
        }
        String returnValue = "(";
        int i = 0;
        while (i < values.length) {
            returnValue = String.valueOf(returnValue) + values[i];
            if (i < values.length - 1) {
                returnValue = String.valueOf(returnValue) + ", ";
            }
            ++i;
        }
        returnValue = String.valueOf(returnValue) + ")";
        return returnValue;
    }

    private void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

