/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.jdbc.metadata;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.List;
import org.kawanfw.sql.servlet.JavaValueBuilder;
import org.kawanfw.sql.util.FrameworkDebug;

public class MethodParametersBuilder {
    private static boolean DEBUG = FrameworkDebug.isSet(MethodParametersBuilder.class);
    private List<String> paramTypes;
    private List<String> paramsValues;
    private Class<?>[] methodParamTypes;
    private Object[] methodParamValues;

    public MethodParametersBuilder(List<String> paramTypes, List<String> paramsValues) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.paramTypes = paramTypes;
        this.paramsValues = paramsValues;
        this.build();
    }

    private void build() throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.methodParamTypes = new Class[this.paramTypes.size()];
        this.methodParamValues = new Object[this.paramsValues.size()];
        int i = 0;
        while (i < this.paramTypes.size()) {
            String value = this.paramsValues.get(i);
            String javaType = this.paramTypes.get(i);
            JavaValueBuilder javaValueBuilder = new JavaValueBuilder(javaType, value);
            this.methodParamTypes[i] = javaValueBuilder.getClassOfValue();
            this.methodParamValues[i] = javaValueBuilder.getValue();
            if (this.methodParamValues[i].equals("NULL")) {
                this.methodParamValues[i] = null;
            }
            this.debug("methodParamTypes[i]: " + this.methodParamTypes[i]);
            this.debug("methodParamValues[i]  : " + this.methodParamValues[i]);
            ++i;
        }
    }

    public Class<?>[] getMethodParamTypes() {
        return this.methodParamTypes;
    }

    public Object[] getMethodParamValues() {
        return this.methodParamValues;
    }

    private void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

