/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.jdbc.metadata.resultset;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import org.kawanfw.sql.jdbc.metadata.ResultSetMetaDataHolder;

public class ResultSetMetaDataBuilder {
    private ResultSet resultSet = null;
    private int columnCount;
    private List<Boolean> autoIncrement = new Vector<Boolean>();
    private List<Boolean> caseSensitive = new Vector<Boolean>();
    private List<Boolean> searchable = new Vector<Boolean>();
    private List<Boolean> currency = new Vector<Boolean>();
    private List<Integer> nullable = new Vector<Integer>();
    private List<Boolean> signed = new Vector<Boolean>();
    private List<Integer> columnDisplaySize = new Vector<Integer>();
    private List<String> columnLabel = new Vector<String>();
    private List<String> columnName = new Vector<String>();
    private List<String> schemaName = new Vector<String>();
    private List<Integer> precision = new Vector<Integer>();
    private List<Integer> scale = new Vector<Integer>();
    private List<String> tableName = new Vector<String>();
    private List<String> catalogName = new Vector<String>();
    private List<Integer> columnType = new Vector<Integer>();
    private List<String> columnTypeName = new Vector<String>();
    private List<Boolean> readOnly = new Vector<Boolean>();
    private List<Boolean> writable = new Vector<Boolean>();
    private List<Boolean> definitelyWritable = new Vector<Boolean>();
    private List<String> columnClassName = new Vector<String>();
    private ResultSetMetaDataHolder resultSetMetaDataHolder;

    public ResultSetMetaDataBuilder(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        this.build();
    }

    private void build() throws SQLException {
        ResultSetMetaData meta = this.resultSet.getMetaData();
        this.fillLists(meta);
        this.resultSetMetaDataHolder = new ResultSetMetaDataHolder();
        this.resultSetMetaDataHolder.setColumnCount(this.columnCount);
        this.resultSetMetaDataHolder.setAutoIncrement(this.autoIncrement);
        this.resultSetMetaDataHolder.setCaseSensitive(this.caseSensitive);
        this.resultSetMetaDataHolder.setSearchable(this.searchable);
        this.resultSetMetaDataHolder.setCurrency(this.currency);
        this.resultSetMetaDataHolder.setNullable(this.nullable);
        this.resultSetMetaDataHolder.setSigned(this.signed);
        this.resultSetMetaDataHolder.setColumnDisplaySize(this.columnDisplaySize);
        this.resultSetMetaDataHolder.setColumnLabel(this.columnLabel);
        this.resultSetMetaDataHolder.setColumnName(this.columnName);
        this.resultSetMetaDataHolder.setSchemaName(this.schemaName);
        this.resultSetMetaDataHolder.setPrecision(this.precision);
        this.resultSetMetaDataHolder.setScale(this.scale);
        this.resultSetMetaDataHolder.setTableName(this.tableName);
        this.resultSetMetaDataHolder.setCatalogName(this.catalogName);
        this.resultSetMetaDataHolder.setColumnType(this.columnType);
        this.resultSetMetaDataHolder.setColumnTypeName(this.columnTypeName);
        this.resultSetMetaDataHolder.setReadOnly(this.readOnly);
        this.resultSetMetaDataHolder.setWritable(this.writable);
        this.resultSetMetaDataHolder.setDefinitelyWritable(this.definitelyWritable);
        this.resultSetMetaDataHolder.setColumnClassName(this.columnClassName);
    }

    private void fillLists(ResultSetMetaData meta) throws SQLException {
        this.columnCount = meta.getColumnCount();
        int i = 1;
        while (i <= this.columnCount) {
            this.autoIncrement.add(meta.isAutoIncrement(i));
            this.caseSensitive.add(meta.isCaseSensitive(i));
            this.searchable.add(meta.isSearchable(i));
            this.currency.add(meta.isCurrency(i));
            this.nullable.add(meta.isNullable(i));
            this.signed.add(meta.isSigned(i));
            this.columnDisplaySize.add(meta.getColumnDisplaySize(i));
            this.columnLabel.add(meta.getColumnLabel(i));
            this.columnName.add(meta.getColumnName(i));
            this.schemaName.add(meta.getSchemaName(i));
            this.precision.add(meta.getPrecision(i));
            this.scale.add(meta.getScale(i));
            this.tableName.add(meta.getTableName(i));
            this.catalogName.add(meta.getCatalogName(i));
            this.columnType.add(meta.getColumnType(i));
            this.columnTypeName.add(meta.getColumnTypeName(i));
            this.readOnly.add(meta.isReadOnly(i));
            this.writable.add(meta.isWritable(i));
            this.definitelyWritable.add(meta.isDefinitelyWritable(i));
            this.columnClassName.add(meta.getColumnClassName(i));
            ++i;
        }
    }

    public ResultSetMetaDataHolder getResultSetMetaDataHolder() {
        return this.resultSetMetaDataHolder;
    }
}

