/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.metadata;

import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.kawanfw.sql.servlet.sql.json_return.JsonUtil;

public class JsonDatabaseMetaData {
    private DatabaseMetaData databaseMetaData = null;

    public JsonDatabaseMetaData(DatabaseMetaData databaseMetaData) {
        this.databaseMetaData = databaseMetaData;
    }

    public String build() throws ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> c = Class.forName(DatabaseMetaData.class.getName());
        Method[] allMethods = c.getDeclaredMethods();
        ArrayList<Method> noParmMethods = new ArrayList<Method>();
        Method[] methodArray = allMethods;
        int n = allMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Class<?>[] pType = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            if (pType.length == 0 && this.isIntStringBooleanReturnType(returnType)) {
                noParmMethods.add(method);
            }
            ++n2;
        }
        JsonGeneratorFactory jf = JsonUtil.getJsonGeneratorFactory(true);
        StringWriter sw = new StringWriter();
        JsonGenerator gen = jf.createGenerator((Writer)sw);
        gen.writeStartObject().write("status", "OK");
        for (Method method : noParmMethods) {
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            Object obj = null;
            try {
                obj = method.invoke((Object)this.databaseMetaData, new Object[0]);
            }
            catch (Exception e) {
                System.err.println(e);
            }
            if (obj == null) {
                String returnTypeStr = this.getReturnTypeName(returnType);
                gen.write(methodName, returnTypeStr);
                continue;
            }
            if (obj instanceof Boolean) {
                boolean result = (Boolean)obj;
                gen.write(methodName, result);
                continue;
            }
            if (obj instanceof String) {
                String result = (String)obj;
                gen.write(methodName, result);
                continue;
            }
            if (obj instanceof Integer) {
                int result = (Integer)obj;
                gen.write(methodName, result);
                continue;
            }
            gen.write(methodName, obj.toString());
        }
        gen.writeEnd();
        gen.close();
        return sw.toString();
    }

    private boolean isIntStringBooleanReturnType(Class<?> returnType) {
        if (returnType.getSimpleName().equalsIgnoreCase("String")) {
            return true;
        }
        if (returnType.getSimpleName().equalsIgnoreCase("Integer")) {
            return true;
        }
        return returnType.getSimpleName().equalsIgnoreCase("Boolean");
    }

    private String getReturnTypeName(Class<?> returnType) {
        if (returnType.getSimpleName().equalsIgnoreCase("String")) {
            return "null";
        }
        if (returnType.getSimpleName().equalsIgnoreCase("Integer")) {
            return "0";
        }
        if (returnType.getSimpleName().equalsIgnoreCase("Boolean")) {
            return "false";
        }
        return "null";
    }
}

