/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.sql;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.sql.PostgreSqlUtil;
import org.kawanfw.sql.util.FrameworkFileUtil;

public class BinaryColumnFormater {
    private static final String NULL_STREAM = "NULL_STREAM";
    private ResultSet resultSet;
    private String productName;
    private int columnType;
    private int columnIndex;
    private String columnName;
    private Set<String> typeBigIntColumnNames;
    private String database;
    private String username;

    public BinaryColumnFormater(HttpServletRequest request, ResultSet resultSet, String productName, int columnType, int columnIndex, String columnName) {
        this.username = request.getParameter("username");
        this.database = request.getParameter("database");
        this.resultSet = resultSet;
        this.productName = productName;
        this.columnType = columnType;
        this.columnIndex = columnIndex;
        this.columnName = columnName;
    }

    public boolean isBinaryColumn() throws SQLException, IOException {
        if (this.columnType == -2 || this.columnType == -3 || this.columnType == -4 || this.columnType == 2004) {
            return true;
        }
        if (this.isPostgreSQL() && this.columnType == -5) {
            if (this.typeBigIntColumnNames == null) {
                Connection connection = this.resultSet.getStatement().getConnection();
                this.typeBigIntColumnNames = PostgreSqlUtil.getTypeBigIntColumnNames(connection);
            }
            if (this.typeBigIntColumnNames.contains(this.columnName.trim().toLowerCase())) {
                return true;
            }
        }
        return false;
    }

    public String formatAndReturnId() throws SQLException, IOException {
        String fileName = String.valueOf(FrameworkFileUtil.getUniqueId()) + ".blob";
        InputStream in = null;
        in = this.isTerradata() ? this.resultSet.getBlob(this.columnIndex).getBinaryStream() : (this.isPostgreSQL() && this.columnType == -5 ? PostgreSqlUtil.getPostgreSqlnputStream(this.resultSet, this.columnIndex) : this.resultSet.getBinaryStream(this.columnIndex));
        String hostFileName = null;
        DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(this.database);
        hostFileName = databaseConfigurator.getBlobsDirectory(this.username) + File.separator + fileName;
        try {
            try {
                Throwable throwable = null;
                Object var7_8 = null;
                try (BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(hostFileName));){
                    if (in == null) {
                        ((OutputStream)outStream).write(NULL_STREAM.getBytes());
                    } else {
                        IOUtils.copy((InputStream)in, (OutputStream)outStream);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        String columnValueStr = fileName;
        return columnValueStr;
    }

    private boolean isTerradata() {
        return this.productName.equals("Teradata");
    }

    private boolean isPostgreSQL() {
        return this.productName.equals("PostgreSQL");
    }
}

