/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.sql;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.util.FrameworkFileUtil;
import org.kawanfw.sql.util.HtmlConverter;

public class ClobColumnFormater {
    private static final String NULL_STREAM = "NULL_STREAM";
    public static String CR_LF = System.getProperty("line.separator");
    private static boolean HTML_ENCONDING_ON = true;
    private ResultSet resultSet;
    private int columnIndex;
    private String username;
    private String database;

    public ClobColumnFormater(HttpServletRequest request, ResultSet resultSet, int columnIndex) {
        this.username = request.getParameter("username");
        this.database = request.getParameter("database");
        this.resultSet = resultSet;
        this.columnIndex = columnIndex;
    }

    public String formatAndReturnId() throws SQLException, IOException {
        String fileName;
        block10: {
            fileName = String.valueOf(FrameworkFileUtil.getUniqueId()) + ".clob.txt";
            Reader reader = this.resultSet.getCharacterStream(this.columnIndex);
            DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(this.database);
            String hostFileName = databaseConfigurator.getBlobsDirectory(this.username) + File.separator + fileName;
            if (reader == null) {
                Throwable throwable = null;
                Object var7_8 = null;
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(hostFileName));){
                    writer.write(NULL_STREAM + CR_LF);
                    break block10;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            BufferedReader br = new BufferedReader(reader);
            this.writeClobFile(br, hostFileName);
        }
        String columnValueStr = fileName;
        return columnValueStr;
    }

    private void writeClobFile(BufferedReader br, String hostFileName) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(hostFileName));){
            String line = null;
            while ((line = br.readLine()) != null) {
                if (HTML_ENCONDING_ON) {
                    line = HtmlConverter.fromHtml(line);
                }
                writer.write(String.valueOf(line) + CR_LF);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

