/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.kawanfw.sql.servlet.sql.PostgreSqlUtil;
import org.kawanfw.sql.util.FrameworkDebug;
import org.postgresql.PGResultSetMetaData;

public class ColumnInfoCreator {
    private static boolean DEBUG = FrameworkDebug.isSet(ColumnInfoCreator.class);
    private ResultSetMetaData meta;
    private boolean isPostgreSQL;
    private List<Integer> columnTypeList = new Vector<Integer>();
    private List<String> columnTypeNameList = new Vector<String>();
    private List<String> columnNameList = new Vector<String>();
    private List<String> columnTableList = new Vector<String>();
    private Map<String, Integer> mapColumnNames = new LinkedHashMap<String, Integer>();
    private PGResultSetMetaData pgResultSetMetaData;

    public ColumnInfoCreator(ResultSet resultSet, String productName) throws SQLException {
        this.meta = resultSet.getMetaData();
        boolean bl = this.isPostgreSQL = productName.equals("PostgreSQL");
        if (this.isPostgreSQL) {
            this.pgResultSetMetaData = (PGResultSetMetaData)resultSet.getMetaData();
        }
        this.create();
    }

    public void create() throws SQLException {
        int cols = this.meta.getColumnCount();
        int i = 1;
        while (i <= cols) {
            this.columnTypeList.add(this.meta.getColumnType(i));
            this.columnNameList.add(this.meta.getColumnName(i));
            this.columnTypeNameList.add(this.meta.getColumnTypeName(i));
            if (this.isPostgreSQL) {
                this.columnTableList.add(PostgreSqlUtil.getTableName(this.pgResultSetMetaData, i));
            } else {
                this.columnTableList.add(this.meta.getTableName(i));
            }
            this.debug("");
            this.debug("meta.getColumnType(" + i + ")    : " + this.meta.getColumnType(i));
            this.debug("meta.getColumnTypeName(" + i + "): " + this.meta.getColumnTypeName(i));
            this.debug("meta.getColumnName(" + i + ")    : " + this.meta.getColumnName(i));
            this.debug("meta.getTableName(" + i + ")     : " + this.meta.getTableName(i));
            ++i;
        }
        LinkedHashMap<String, Integer> mapColumnNames = new LinkedHashMap<String, Integer>();
        int i2 = 0;
        while (i2 < this.columnNameList.size()) {
            mapColumnNames.put(this.columnNameList.get(i2), i2);
            ++i2;
        }
    }

    public List<Integer> getColumnTypeList() {
        return this.columnTypeList;
    }

    public List<String> getColumnTypeNameList() {
        return this.columnTypeNameList;
    }

    public List<String> getColumnNameList() {
        return this.columnNameList;
    }

    public List<String> getColumnTableList() {
        return this.columnTableList;
    }

    public Map<String, Integer> getMapColumnNames() {
        return this.mapColumnNames;
    }

    protected void debug(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }
}

