/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.sql;

import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.driver.OracleConnection;
import org.kawanfw.sql.api.server.DatabaseConfigurationException;
import org.kawanfw.sql.api.util.SqlUtil;
import org.kawanfw.sql.servlet.sql.DbEngineManagerUtil;
import org.kawanfw.sql.util.FrameworkDebug;

public class DbEngineManager {
    private static boolean DEBUG = FrameworkDebug.isSet(DbEngineManager.class);

    protected DbEngineManager() {
    }

    public static String addLmt1(String sqlOrderParm, Connection connection) throws SQLException {
        String sqlOrder = sqlOrderParm.trim();
        if (!sqlOrder.toLowerCase().startsWith("select ")) {
            return sqlOrder;
        }
        SqlUtil sqlUtil = new SqlUtil(connection);
        if (sqlUtil.isPostgreSQL() || sqlUtil.isMySQL() || sqlUtil.isH2() || sqlUtil.isHSQLDB()) {
            if (DbEngineManagerUtil.containsWord(sqlOrder, "limit")) {
                return sqlOrder;
            }
            sqlOrder = DbEngineManagerUtil.removeSemicolon(sqlOrder);
            sqlOrder = String.valueOf(sqlOrder) + " LIMIT 1";
            DbEngineManager.printOrder(sqlUtil.getDatabaseProductName(), sqlOrder);
            return sqlOrder;
        }
        if (sqlUtil.isSQLServer() || sqlUtil.isSQLAnywhere() || sqlUtil.isAdaptiveServerEnterprise()) {
            sqlOrder = String.valueOf(sqlOrder.substring(0, "select".length())) + " TOP 1 " + sqlOrder.substring("select".length() + 1);
            DbEngineManager.printOrder(sqlUtil.getDatabaseProductName(), sqlOrder);
            return sqlOrder;
        }
        if (sqlUtil.isInformix()) {
            sqlOrder = String.valueOf(sqlOrder.substring(0, "select".length())) + " FIRST 1 " + sqlOrder.substring("select".length() + 1);
            DbEngineManager.printOrder(sqlUtil.getDatabaseProductName(), sqlOrder);
            return sqlOrder;
        }
        if (sqlUtil.isDB2() || sqlUtil.isIngres()) {
            if (DbEngineManagerUtil.containsWord(sqlOrder, "fetch")) {
                return sqlOrder;
            }
            sqlOrder = DbEngineManagerUtil.removeSemicolon(sqlOrder);
            sqlOrder = String.valueOf(sqlOrder) + " FETCH FIRST 1 ROWS ONLY";
            DbEngineManager.printOrder(sqlUtil.getDatabaseProductName(), sqlOrder);
            return sqlOrder;
        }
        if (sqlUtil.isOracle()) {
            if (!DbEngineManager.isOracleVersionGtOrEq12c(connection)) {
                DbEngineManager.printOrder(sqlUtil.getDatabaseProductName(), sqlOrder);
                return sqlOrder;
            }
            if (DbEngineManagerUtil.containsWord(sqlOrder, "fetch")) {
                return sqlOrder;
            }
            sqlOrder = DbEngineManagerUtil.removeSemicolon(sqlOrder);
            sqlOrder = String.valueOf(sqlOrder) + " FETCH NEXT 1 ROWS ONLY";
            DbEngineManager.printOrder(sqlUtil.getDatabaseProductName(), sqlOrder);
            return sqlOrder;
        }
        DbEngineManager.printOrder(sqlUtil.getDatabaseProductName(), sqlOrder);
        return sqlOrder;
    }

    private static void printOrder(String databaseProductName, String sqlOrder) {
        DbEngineManager.debug("databaseProductName: " + databaseProductName);
        DbEngineManager.debug("sqlOrder LIMIT 1   : " + sqlOrder);
    }

    public static boolean checkDb(Properties properties, Connection connection) throws DatabaseConfigurationException {
        return true;
    }

    public static Array createArrayOf(Connection connection, String typeName, Object[] elements) throws SQLException {
        Array array = null;
        if (new SqlUtil(connection).isOracle()) {
            if (connection.isWrapperFor(OracleConnection.class)) {
                OracleConnection oracleConnection = connection.unwrap(OracleConnection.class);
                array = oracleConnection.createARRAY(typeName, (Object)elements);
            } else {
                array = ((oracle.jdbc.OracleConnection)connection).createARRAY(typeName, (Object)elements);
            }
        } else {
            array = connection.createArrayOf(typeName, elements);
        }
        return array;
    }

    public static boolean isOracleVersionGtOrEq12c(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        int versionMajor = databaseMetaData.getDatabaseMajorVersion();
        int versionMinnor = databaseMetaData.getDatabaseMinorVersion();
        if (versionMajor < 12) {
            return false;
        }
        if (versionMajor == 12) {
            return versionMinnor >= 1;
        }
        return true;
    }

    public static void debug(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }
}

