/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.sql;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.DefaultDatabaseConfigurator;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.util.logging.LoggerWrapper;
import org.slf4j.Logger;

public class LoggerUtil {
    protected LoggerUtil() {
    }

    public static void log(HttpServletRequest request, Exception exception, String aceQLErrorMessage) throws IOException {
        String database = request.getParameter("database");
        DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(database);
        Logger logger = databaseConfigurator.getLogger();
        LoggerWrapper.log(logger, aceQLErrorMessage, exception);
    }

    public static void log(HttpServletRequest request, Throwable exception) throws IOException {
        String database = request.getParameter("database");
        DatabaseConfigurator databaseConfigurator = null;
        if (database == null) {
            databaseConfigurator = new DefaultDatabaseConfigurator();
        } else {
            databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(database);
            if (databaseConfigurator == null) {
                databaseConfigurator = new DefaultDatabaseConfigurator();
            }
        }
        Logger logger = databaseConfigurator.getLogger();
        if (logger != null) {
            LoggerWrapper.log(logger, "Exception: ", exception);
        } else {
            System.err.println("Logger is null!");
            System.err.println("Exception: " + exception);
        }
    }
}

