/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.io.IOUtils;
import org.kawanfw.sql.api.server.StatementAnalyzer;
import org.kawanfw.sql.api.util.SqlUtil;
import org.kawanfw.sql.util.FrameworkDebug;
import org.postgresql.PGConnection;
import org.postgresql.PGResultSetMetaData;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

public class PostgreSqlUtil {
    private static boolean DEBUG = FrameworkDebug.isSet(PostgreSqlUtil.class);

    protected PostgreSqlUtil() {
    }

    public static String getTableName(PGResultSetMetaData meta, int columnIndex) throws SQLException {
        String tableName = meta.getBaseTableName(columnIndex);
        return tableName;
    }

    public static boolean isPostgreSqlStatementWithOID(Connection connection, String sql) throws SQLException, IOException {
        PostgreSqlUtil.debug("before new SqlUtil(connection).isPostgreSQL()");
        if (!new SqlUtil(connection).isPostgreSQL()) {
            return false;
        }
        String catalog = null;
        String schema = null;
        ResultSet rs = null;
        StatementAnalyzer statementAnalyzer = new StatementAnalyzer(sql, new Vector<Object>());
        List<String> tables = statementAnalyzer.getTables();
        if (tables.isEmpty()) {
            return false;
        }
        String table = tables.get(0);
        table = table.toLowerCase();
        PostgreSqlUtil.debug("table: " + table);
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        try {
            rs = databaseMetaData.getColumns(catalog, schema, table, null);
            PostgreSqlUtil.debug("Before rs.next");
            while (rs.next()) {
                int columnType = rs.getInt(5);
                if (columnType != -5) continue;
                return true;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return false;
    }

    public static Set<String> getTypeBigIntColumnNames(Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null!");
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String catalog = null;
        String schema = "public";
        String table = null;
        TreeSet<String> typeBigIntColumnNames = new TreeSet<String>();
        try (ResultSet rs = null;){
            rs = databaseMetaData.getColumns(catalog, schema, table, null);
            PostgreSqlUtil.debug("Before rs.next");
            while (rs.next()) {
                int columnType = rs.getInt(5);
                if (columnType != -5) continue;
                if (DEBUG) {
                    System.out.println();
                    System.out.println(rs.getString(1));
                    System.out.println(rs.getString(2));
                    System.out.println(rs.getString(4));
                }
                String columnName = rs.getString(4).toLowerCase();
                typeBigIntColumnNames.add(columnName);
            }
        }
        return typeBigIntColumnNames;
    }

    public static InputStream getPostgreSqlnputStream(ResultSet resultSet, int columnIndex) throws SQLException {
        Statement statement = resultSet.getStatement();
        Connection conn = statement.getConnection();
        LargeObjectManager lobj = ((PGConnection)conn).getLargeObjectAPI();
        long oid = resultSet.getLong(columnIndex);
        if (oid < 1L) {
            return null;
        }
        LargeObject obj = lobj.open(oid, 262144);
        InputStream in = obj.getInputStream();
        return in;
    }

    public static void setPostgreSqlParameterWithLargeObject(PreparedStatement preparedStatement, int parameterIndex, InputStream in, Connection connection) throws SQLException, IOException {
        LargeObjectManager lobj = ((PGConnection)connection).getLargeObjectAPI();
        long oid = lobj.createLO(393216);
        try (LargeObject obj = lobj.open(oid, 131072);){
            Throwable throwable = null;
            Object var9_9 = null;
            try (OutputStream out = obj.getOutputStream();){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        preparedStatement.setLong(parameterIndex, oid);
    }

    protected static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

