/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.sql;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.kawanfw.sql.jdbc.metadata.ResultSetMetaDataHolder;
import org.kawanfw.sql.metadata.util.GsonWsUtil;
import org.kawanfw.sql.servlet.jdbc.metadata.resultset.ResultSetMetaDataBuilder;
import org.kawanfw.sql.servlet.sql.BinaryColumnFormater;
import org.kawanfw.sql.servlet.sql.ClobColumnFormater;
import org.kawanfw.sql.servlet.sql.ColumnInfoCreator;
import org.kawanfw.sql.servlet.sql.JavaSqlConversion;
import org.kawanfw.sql.servlet.sql.ResultSetWriterUtil;
import org.kawanfw.sql.tomcat.StaticParms;
import org.kawanfw.sql.util.FrameworkDebug;

public class ResultSetWriter {
    static final String NULL = "NULL";
    private static boolean DEBUG = FrameworkDebug.isSet(ResultSetWriter.class);
    public static String CR_LF = System.getProperty("line.separator");
    private String sqlOrder = null;
    private boolean fillResultSetMetaData = false;
    private HttpServletRequest request;
    private Boolean doColumnTypes = false;
    private JsonGenerator gen = null;

    public ResultSetWriter(HttpServletRequest request, String sqlOrder, JsonGenerator gen, boolean fillResultSetMetaData) {
        this.sqlOrder = sqlOrder;
        this.request = request;
        this.gen = gen;
        String columnTypes = request.getParameter("column_types");
        this.doColumnTypes = Boolean.parseBoolean(columnTypes);
        this.fillResultSetMetaData = fillResultSetMetaData;
        this.debug("fillResultSetMetaData: " + fillResultSetMetaData);
    }

    public ResultSetWriter(String sqlOrder) {
        this.sqlOrder = sqlOrder;
    }

    public void write(ResultSet resultSet) throws SQLException, IOException {
        try {
            if (resultSet == null) {
                throw new SQLException("resultSet is null!");
            }
            String productName = ResultSetWriterUtil.getDatabaseProductName(resultSet);
            ColumnInfoCreator columnInfoCreator = new ColumnInfoCreator(resultSet, productName);
            List<Integer> columnTypeList = columnInfoCreator.getColumnTypeList();
            List<String> columnTypeNameList = columnInfoCreator.getColumnTypeNameList();
            List<String> columnNameList = columnInfoCreator.getColumnNameList();
            List<String> columnTableList = columnInfoCreator.getColumnTableList();
            this.writeResultSetMetaData(resultSet);
            this.writeColumnTypes(columnTypeList);
            this.gen.writeStartArray("query_rows").writeStartObject();
            int row_count = 0;
            while (resultSet.next()) {
                this.gen.writeStartArray("row_" + ++row_count);
                int i = 0;
                while (i < columnTypeList.size()) {
                    int columnIndex = i + 1;
                    int columnType = columnTypeList.get(i);
                    String columnTypeName = columnTypeNameList.get(i);
                    String columnName = columnNameList.get(i);
                    String columnTable = columnTableList.get(i);
                    this.debugColumnInfo(columnIndex, columnType, columnTypeName, columnName, columnTable);
                    Object columnValue = null;
                    String columnValueStr = null;
                    BinaryColumnFormater binaryColumnFormater = new BinaryColumnFormater(this.request, resultSet, productName, columnType, columnIndex, columnName);
                    if (binaryColumnFormater.isBinaryColumn()) {
                        this.debug("isBinaryColumn: true");
                        columnValueStr = binaryColumnFormater.formatAndReturnId();
                        this.debug("isBinaryColumn:columnValueStr: " + columnValueStr);
                    } else if (ResultSetWriterUtil.isNStringColumn(columnType)) {
                        columnValue = resultSet.getNString(columnIndex);
                        columnValueStr = ResultSetWriterUtil.treatNullValue(resultSet, columnValue);
                    } else if (this.isClobColumn(columnType)) {
                        ClobColumnFormater clobColumnFormater = new ClobColumnFormater(this.request, resultSet, columnIndex);
                        columnValueStr = clobColumnFormater.formatAndReturnId();
                    } else if (columnType == 2003) {
                        columnValueStr = ResultSetWriterUtil.formatArrayColumn(resultSet, columnIndex);
                    } else if (ResultSetWriterUtil.isDateTime(columnType)) {
                        columnValueStr = ResultSetWriterUtil.formatDateTimeColumn(resultSet, columnType, columnIndex);
                    } else if (columnType == -8) {
                        columnValueStr = ResultSetWriterUtil.formatRowIdColumn(this.request, resultSet, columnIndex);
                    } else {
                        try {
                            columnValue = resultSet.getObject(columnIndex);
                            this.debug("columnValue: " + columnValue);
                        }
                        catch (Exception e) {
                            throw new SQLException(String.valueOf(columnType) + "Type/TypeName/ColName " + columnTypeNameList.get(i) + " " + columnName, e);
                        }
                        columnValueStr = ResultSetWriterUtil.treatNullValue(resultSet, columnValue);
                    }
                    this.debug("columnValueStr : " + columnValueStr);
                    this.gen.writeStartObject();
                    this.writeColumn(columnName, columnValue, columnValueStr);
                    this.gen.writeEnd();
                    ++i;
                }
                this.gen.writeEnd();
                if (!StaticParms.FLUSH_EACH_RESULT_SET_ROW) continue;
                this.gen.flush();
            }
            this.gen.writeEnd();
            this.gen.writeEnd();
            this.gen.write("row_count", row_count);
            this.gen.flush();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void writeResultSetMetaData(ResultSet resultSet) throws SQLException {
        if (this.fillResultSetMetaData) {
            ResultSetMetaDataBuilder resultSetMetaDataBuilder = new ResultSetMetaDataBuilder(resultSet);
            ResultSetMetaDataHolder resultSetMetaDataHolder = resultSetMetaDataBuilder.getResultSetMetaDataHolder();
            String jsonString = GsonWsUtil.getJSonString(resultSetMetaDataHolder);
            this.gen.write("ResultSetMetaData", jsonString);
        }
    }

    private void writeColumn(String columnName, Object columnValue, String columnValueStr) throws NumberFormatException {
        if (StringUtils.isNumeric((CharSequence)columnValueStr)) {
            if (columnValue instanceof Integer) {
                this.gen.write(columnName, Integer.parseInt(columnValueStr));
            } else if (columnValue instanceof Double) {
                this.gen.write(columnName, Double.parseDouble(columnValueStr));
            } else if (columnValue instanceof Float) {
                this.gen.write(columnName, (double)Float.parseFloat(columnValueStr));
            } else if (columnValue instanceof Long) {
                this.gen.write(columnName, Long.parseLong(columnValueStr));
            } else if (columnValue instanceof BigDecimal) {
                this.gen.write(columnName, new BigDecimal(columnValueStr));
            } else {
                this.gen.write(columnName, columnValueStr);
            }
        } else {
            this.gen.write(columnName, columnValueStr);
        }
    }

    public void debugColumnInfo(int columnIndex, int columnType, String columnTypeName, String columnName, String columnTable) {
        this.debug("");
        this.debug("columnIndex    : " + columnIndex);
        this.debug("columnType     : " + columnType);
        this.debug("columnTypeName : " + columnTypeName);
        this.debug("columnName     : " + columnName);
        this.debug("columnTable    : " + columnTable);
    }

    private void writeColumnTypes(List<Integer> columnTypeList) {
        if (this.doColumnTypes.booleanValue()) {
            this.gen.writeStartArray("column_types");
            int i = 0;
            while (i < columnTypeList.size()) {
                int columnType = columnTypeList.get(i);
                this.gen.write(JavaSqlConversion.fromJavaToSql(columnType));
                ++i;
            }
            this.gen.writeEnd();
        }
    }

    private boolean isClobColumn(int columnType) {
        if (this.sqlOrder.equals("ResultSetMetaData")) {
            return false;
        }
        return columnType == 2005 || columnType == -1 || columnType == 2011;
    }

    protected void debug(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }
}

